/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.math.BigDecimal;
import java.util.Comparator;
import org.assertj.core.internal.Doubles;
import org.assertj.core.internal.Floats;

public class ComparatorFactory {
    public static final ComparatorFactory INSTANCE = new ComparatorFactory();

    public Comparator<Double> doubleComparatorWithPrecision(final double precision) {
        return new Comparator<Double>(){
            final /* synthetic */ ComparatorFactory this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public int compare(Double double1, Double double2) {
                if (Doubles.instance().isNanOrInfinite(precision)) {
                    throw new IllegalArgumentException("Precision should not be Nan or Infinity!");
                }
                if (Doubles.instance().isNanOrInfinite(double1) || Doubles.instance().isNanOrInfinite(double2)) {
                    return Double.compare(double1, double2);
                }
                return ComparatorFactory.isWithinPrecision(double1, double2, precision) ? 0 : ComparatorFactory.asBigDecimal(double1).compareTo(ComparatorFactory.asBigDecimal(double2));
            }

            public String toString() {
                return "double comparator at precision " + precision + " (values are considered equal if diff == precision)";
            }
        };
    }

    public Comparator<Float> floatComparatorWithPrecision(final float precision) {
        return new Comparator<Float>(){
            final /* synthetic */ ComparatorFactory this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public int compare(Float float1, Float float2) {
                Floats floats = Floats.instance();
                if (floats.isNanOrInfinite(Float.valueOf(precision))) {
                    throw new IllegalArgumentException("Precision should not be Nan or Infinity!");
                }
                if (floats.isNanOrInfinite(float1) || floats.isNanOrInfinite(float2)) {
                    return Float.compare(float1.floatValue(), float2.floatValue());
                }
                return ComparatorFactory.isWithinPrecision(float1, float2, Float.valueOf(precision)) ? 0 : ComparatorFactory.asBigDecimal(float1).compareTo(ComparatorFactory.asBigDecimal(float2));
            }

            public String toString() {
                return "float comparator at precision " + precision + " (values are considered equal if diff == precision)";
            }
        };
    }

    private static <T extends Number> BigDecimal asBigDecimal(T number) {
        return new BigDecimal(String.valueOf(number));
    }

    private static <T extends Number> boolean isWithinPrecision(T actual, T expected, T precision) {
        BigDecimal precisionAsBigDecimal;
        BigDecimal actualBigDecimal;
        BigDecimal expectedBigDecimal = ComparatorFactory.asBigDecimal(expected);
        BigDecimal absDifference = expectedBigDecimal.subtract(actualBigDecimal = ComparatorFactory.asBigDecimal(actual)).abs();
        return absDifference.compareTo(precisionAsBigDecimal = ComparatorFactory.asBigDecimal(precision)) <= 0;
    }
}

