/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.potion;

import com.google.common.base.Suppliers;
import io.papermc.paper.world.flag.FeatureDependant;
import java.util.List;
import java.util.function.Supplier;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum PotionType implements Keyed,
FeatureDependant
{
    AWKWARD("awkward"),
    FIRE_RESISTANCE("fire_resistance"),
    HARMING("harming"),
    HEALING("healing"),
    INFESTED("infested"),
    INVISIBILITY("invisibility"),
    LEAPING("leaping"),
    LONG_FIRE_RESISTANCE("long_fire_resistance"),
    LONG_INVISIBILITY("long_invisibility"),
    LONG_LEAPING("long_leaping"),
    LONG_NIGHT_VISION("long_night_vision"),
    LONG_POISON("long_poison"),
    LONG_REGENERATION("long_regeneration"),
    LONG_SLOW_FALLING("long_slow_falling"),
    LONG_SLOWNESS("long_slowness"),
    LONG_STRENGTH("long_strength"),
    LONG_SWIFTNESS("long_swiftness"),
    LONG_TURTLE_MASTER("long_turtle_master"),
    LONG_WATER_BREATHING("long_water_breathing"),
    LONG_WEAKNESS("long_weakness"),
    LUCK("luck"),
    MUNDANE("mundane"),
    NIGHT_VISION("night_vision"),
    OOZING("oozing"),
    POISON("poison"),
    REGENERATION("regeneration"),
    SLOW_FALLING("slow_falling"),
    SLOWNESS("slowness"),
    STRENGTH("strength"),
    STRONG_HARMING("strong_harming"),
    STRONG_HEALING("strong_healing"),
    STRONG_LEAPING("strong_leaping"),
    STRONG_POISON("strong_poison"),
    STRONG_REGENERATION("strong_regeneration"),
    STRONG_SLOWNESS("strong_slowness"),
    STRONG_STRENGTH("strong_strength"),
    STRONG_SWIFTNESS("strong_swiftness"),
    STRONG_TURTLE_MASTER("strong_turtle_master"),
    SWIFTNESS("swiftness"),
    THICK("thick"),
    TURTLE_MASTER("turtle_master"),
    WATER("water"),
    WATER_BREATHING("water_breathing"),
    WEAKNESS("weakness"),
    WEAVING("weaving"),
    WIND_CHARGED("wind_charged");

    private final NamespacedKey key;
    private final Supplier<InternalPotionData> internalPotionDataSupplier;

    private PotionType(String key) {
        this.key = NamespacedKey.minecraft(key);
        this.internalPotionDataSupplier = Suppliers.memoize(() -> Bukkit.getUnsafe().getInternalPotionData(this.key));
    }

    @Deprecated(since="1.20.2")
    @Nullable
    public PotionEffectType getEffectType() {
        return this.internalPotionDataSupplier.get().getEffectType();
    }

    @NotNull
    public List<PotionEffect> getPotionEffects() {
        return this.internalPotionDataSupplier.get().getPotionEffects();
    }

    @Deprecated(since="1.20.2")
    public boolean isInstant() {
        return this.internalPotionDataSupplier.get().isInstant();
    }

    public boolean isUpgradeable() {
        return this.internalPotionDataSupplier.get().isUpgradeable();
    }

    public boolean isExtendable() {
        return this.internalPotionDataSupplier.get().isExtendable();
    }

    public int getMaxLevel() {
        return this.internalPotionDataSupplier.get().getMaxLevel();
    }

    @Deprecated(since="1.9")
    @Nullable
    public static PotionType getByEffect(@Nullable PotionEffectType effectType) {
        if (effectType == null) {
            return WATER;
        }
        for (PotionType type : PotionType.values()) {
            if (!effectType.equals(type.getEffectType())) continue;
            return type;
        }
        return null;
    }

    @Override
    @NotNull
    public NamespacedKey getKey() {
        return this.key;
    }

    @Deprecated(since="1.20.2", forRemoval=true)
    @ApiStatus.Internal
    public static interface InternalPotionData {
        public PotionEffectType getEffectType();

        public List<PotionEffect> getPotionEffects();

        public boolean isInstant();

        public boolean isUpgradeable();

        public boolean isExtendable();

        public int getMaxLevel();
    }
}

