/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.map;

import com.google.common.base.Preconditions;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MapPalette {
    @NotNull
    static final Color[] colors = new Color[]{new Color(0, true), new Color(0, true), new Color(0, true), new Color(0, true), new Color(5864743), new Color(7182640), new Color(8368696), new Color(4415005), new Color(11445363), new Color(14010764), new Color(16247203), new Color(8551254), new Color(0x8C8C8C), new Color(0xABABAB), new Color(0xC7C7C7), new Color(0x696969), new Color(0xB40000), new Color(0xDC0000), new Color(0xFF0000), new Color(0x870000), new Color(7368884), new Color(9079516), new Color(0xA0A0FF), new Color(5526663), new Color(0x757575), new Color(0x909090), new Color(0xA7A7A7), new Color(0x585858), new Color(22272), new Color(27136), new Color(31744), new Color(16640), new Color(0xB4B4B4), new Color(0xDCDCDC), new Color(0xFFFFFF), new Color(0x878787), new Color(7566977), new Color(9277598), new Color(10791096), new Color(5658721), new Color(6966326), new Color(8543810), new Color(9923917), new Color(5191976), new Color(0x4F4F4F), new Color(0x606060), new Color(0x707070), new Color(0x3B3B3B), new Color(2960820), new Color(3618780), new Color(0x4040FF), new Color(2171271), new Color(6575154), new Color(8087102), new Color(9402184), new Color(4931366), new Color(11841964), new Color(14473683), new Color(0xFFFCF5), new Color(8881537), new Color(9984292), new Color(12217644), new Color(14188339), new Color(7488283), new Color(8205720), new Color(10043834), new Color(11685080), new Color(6170738), new Color(4746392), new Color(5801146), new Color(6724056), new Color(3559794), new Color(10592548), new Color(0xC5C52C), new Color(0xE5E533), new Color(7960859), new Color(5869585), new Color(7188501), new Color(8375321), new Color(4418573), new Color(11164020), new Color(13659534), new Color(15892389), new Color(8405847), new Color(0x353535), new Color(0x414141), new Color(0x4C4C4C), new Color(0x282828), new Color(0x6C6C6C), new Color(0x848484), new Color(0x999999), new Color(0x515151), new Color(3496300), new Color(4287876), new Color(5013401), new Color(2638673), new Color(5844093), new Color(7157401), new Color(8339378), new Color(4399454), new Color(2372989), new Color(2900377), new Color(3361970), new Color(1779806), new Color(4732196), new Color(5783852), new Color(6704179), new Color(3549211), new Color(4741412), new Color(5795116), new Color(6717235), new Color(3556123), new Color(7087140), new Color(8662060), new Color(0x993333), new Color(0x511B1B), new Color(0x111111), new Color(0x151515), new Color(0x191919), new Color(855309), new Color(11577398), new Color(14142786), new Color(16445005), new Color(8683048), new Color(4233878), new Color(5225655), new Color(6085589), new Color(0x307370), new Color(3431092), new Color(4157148), new Color(4882687), new Color(2573191), new Color(39208), new Color(47922), new Color(55610), new Color(29214), new Color(5979170), new Color(7293482), new Color(8476209), new Color(4467993), new Color(5177600), new Color(0x600100), new Color(0x700200), new Color(3866880), new Color(9665649), new Color(11835530), new Color(13742497), new Color(7232853), new Color(7354649), new Color(8996383), new Color(10441252), new Color(5516051), new Color(6896972), new Color(8407901), new Color(9787244), new Color(5123641), new Color(5196897), new Color(6315383), new Color(7367818), new Color(3881289), new Color(8609049), new Color(10514975), new Color(12223780), new Color(6440467), new Color(4739621), new Color(5792813), new Color(6780213), new Color(3554588), new Color(7353911), new Color(9060931), new Color(10505550), new Color(5515305), new Color(2628632), new Color(3220254), new Color(0x392923), new Color(1971474), new Color(6245189), new Color(7625812), new Color(8874850), new Color(4667443), new Color(4014144), new Color(0x4B4F4F), new Color(0x575C5C), new Color(3026992), new Color(5649214), new Color(6897227), new Color(8014168), new Color(4204078), new Color(3484480), new Color(4273487), new Color(4996700), new Color(2629680), new Color(3482392), new Color(4270878), new Color(4993571), new Color(2628114), new Color(3488029), new Color(4277796), new Color(5001770), new Color(2632470), new Color(6564384), new Color(8008487), new Color(9321518), new Color(4923160), new Color(1707787), new Color(2036237), new Color(2430480), new Color(1248008), new Color(8724770), new Color(10692906), new Color(12398641), new Color(6560025), new Color(6827076), new Color(8336979), new Color(9715553), new Color(5120307), new Color(0x401114), new Color(5182745), new Color(6035741), new Color(3149071), new Color(1005662), new Color(1207411), new Color(1474182), new Color(737862), new Color(2647138), new Color(3308152), new Color(3837580), new Color(1985354), new Color(3940139), new Color(4859189), new Color(5647422), new Color(2955040), new Color(950109), new Color(1153906), new Color(1356933), new Color(679750), new Color(0x464646), new Color(0x565656), new Color(0x646464), new Color(0x343434), new Color(9993063), new Color(12228222), new Color(14200723), new Color(7494733), new Color(5862761), new Color(7180417), new Color(8365974), new Color(4413519)};
    @Deprecated(since="1.6.2")
    public static final byte TRANSPARENT = 0;
    @Deprecated(since="1.6.2")
    public static final byte LIGHT_GREEN = 4;
    @Deprecated(since="1.6.2")
    public static final byte LIGHT_BROWN = 8;
    @Deprecated(since="1.6.2")
    public static final byte GRAY_1 = 12;
    @Deprecated(since="1.6.2")
    public static final byte RED = 16;
    @Deprecated(since="1.6.2")
    public static final byte PALE_BLUE = 20;
    @Deprecated(since="1.6.2")
    public static final byte GRAY_2 = 24;
    @Deprecated(since="1.6.2")
    public static final byte DARK_GREEN = 28;
    @Deprecated(since="1.6.2")
    public static final byte WHITE = 32;
    @Deprecated(since="1.6.2")
    public static final byte LIGHT_GRAY = 36;
    @Deprecated(since="1.6.2")
    public static final byte BROWN = 40;
    @Deprecated(since="1.6.2")
    public static final byte DARK_GRAY = 44;
    @Deprecated(since="1.6.2")
    public static final byte BLUE = 48;
    @Deprecated(since="1.6.2")
    public static final byte DARK_BROWN = 52;
    private static MapColorCache mapColorCache;

    private MapPalette() {
    }

    private static double getDistance(@NotNull Color c1, @NotNull Color c2) {
        int rsum = c1.getRed() + c2.getRed();
        int r = c1.getRed() - c2.getRed();
        int g = c1.getGreen() - c2.getGreen();
        int b = c1.getBlue() - c2.getBlue();
        int weightR = 1024 + rsum;
        int weightG = 2048;
        int weightB = 1024 + (510 - rsum);
        return weightR * r * r + weightG * g * g + weightB * b * b;
    }

    @NotNull
    public static BufferedImage resizeImage(@Nullable Image image) {
        BufferedImage result = new BufferedImage(128, 128, 2);
        Graphics2D graphics = result.createGraphics();
        graphics.drawImage(image, 0, 0, 128, 128, null);
        graphics.dispose();
        return result;
    }

    @Deprecated(since="1.6.2", forRemoval=true)
    @NotNull
    public static byte[] imageToBytes(@NotNull Image image) {
        BufferedImage temp = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics2D graphics = temp.createGraphics();
        graphics.drawImage(image, 0, 0, null);
        graphics.dispose();
        int[] pixels = new int[temp.getWidth() * temp.getHeight()];
        temp.getRGB(0, 0, temp.getWidth(), temp.getHeight(), pixels, 0, temp.getWidth());
        byte[] result = new byte[temp.getWidth() * temp.getHeight()];
        for (int i = 0; i < pixels.length; ++i) {
            result[i] = MapPalette.matchColor(new Color(pixels[i], true));
        }
        return result;
    }

    @Deprecated(since="1.6.2", forRemoval=true)
    public static byte matchColor(int r, int g, int b) {
        return MapPalette.matchColor(new Color(r, g, b));
    }

    @Deprecated(since="1.6.2", forRemoval=true)
    public static byte matchColor(@NotNull Color color) {
        if (color.getAlpha() < 128) {
            return 0;
        }
        if (mapColorCache != null && mapColorCache.isCached()) {
            return mapColorCache.matchColor(color);
        }
        int index = 0;
        double best = -1.0;
        for (int i = 4; i < colors.length; ++i) {
            double distance = MapPalette.getDistance(color, colors[i]);
            if (!(distance < best) && best != -1.0) continue;
            best = distance;
            index = i;
        }
        return (byte)(index < 128 ? index : -129 + (index - 127));
    }

    @Deprecated(since="1.6.2", forRemoval=true)
    @NotNull
    public static Color getColor(byte index) {
        return colors[index >= 0 ? index : index + 256];
    }

    public static void setMapColorCache(@NotNull MapColorCache mapColorCache) {
        Preconditions.checkState((MapPalette.mapColorCache == null ? 1 : 0) != 0, (Object)"Map color cache already set");
        MapPalette.mapColorCache = mapColorCache;
    }

    public static interface MapColorCache {
        public boolean isCached();

        @ApiStatus.Internal
        public byte matchColor(@NotNull Color var1);
    }
}

