/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.event.world;

import java.util.List;
import org.bukkit.Location;
import org.bukkit.TreeType;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;
import org.bukkit.event.world.WorldEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StructureGrowEvent
extends WorldEvent
implements Cancellable {
    private static final HandlerList HANDLER_LIST = new HandlerList();
    private final Location location;
    private final TreeType species;
    private final boolean bonemeal;
    private final Player player;
    private final List<BlockState> blocks;
    private boolean cancelled;

    @ApiStatus.Internal
    public StructureGrowEvent(@NotNull Location location, @NotNull TreeType species, boolean bonemeal, @Nullable Player player, @NotNull List<BlockState> blocks) {
        super(location.getWorld());
        this.location = location;
        this.species = species;
        this.bonemeal = bonemeal;
        this.player = player;
        this.blocks = blocks;
    }

    @NotNull
    public Location getLocation() {
        return this.location.clone();
    }

    @NotNull
    public TreeType getSpecies() {
        return this.species;
    }

    public boolean isFromBonemeal() {
        return this.bonemeal;
    }

    @Nullable
    public Player getPlayer() {
        return this.player;
    }

    @NotNull
    public List<BlockState> getBlocks() {
        return this.blocks;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }

    @Override
    @NotNull
    public HandlerList getHandlers() {
        return HANDLER_LIST;
    }

    @NotNull
    public static HandlerList getHandlerList() {
        return HANDLER_LIST;
    }
}

