/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.event.entity;

import java.util.Collections;
import java.util.Map;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.HandlerList;
import org.bukkit.event.entity.EntityEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Unmodifiable;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class EntityEquipmentChangedEvent
extends EntityEvent {
    private static final HandlerList HANDLER_LIST = new HandlerList();
    private final Map<EquipmentSlot, EquipmentChange> equipmentChanges;

    @ApiStatus.Internal
    public EntityEquipmentChangedEvent(LivingEntity entity, Map<EquipmentSlot, EquipmentChange> equipmentChanges) {
        super(entity);
        this.equipmentChanges = equipmentChanges;
    }

    @Override
    public LivingEntity getEntity() {
        return (LivingEntity)this.entity;
    }

    public @Unmodifiable Map<EquipmentSlot, EquipmentChange> getEquipmentChanges() {
        return Collections.unmodifiableMap(this.equipmentChanges);
    }

    @Override
    public HandlerList getHandlers() {
        return HANDLER_LIST;
    }

    public static HandlerList getHandlerList() {
        return HANDLER_LIST;
    }

    @ApiStatus.NonExtendable
    public static interface EquipmentChange {
        @Contract(pure=true, value="-> new")
        public ItemStack oldItem();

        @Contract(pure=true, value="-> new")
        public ItemStack newItem();
    }
}

