/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.entity;

import com.google.common.base.Preconditions;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import java.util.Locale;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.key.KeyPattern;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Entity;
import org.bukkit.util.OldEnum;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Frog
extends Animals {
    @Nullable
    public Entity getTongueTarget();

    public void setTongueTarget(@Nullable Entity var1);

    @NotNull
    public Variant getVariant();

    public void setVariant(@NotNull Variant var1);

    public static interface Variant
    extends OldEnum<Variant>,
    Keyed {
        public static final Variant COLD = Variant.getVariant("cold");
        public static final Variant TEMPERATE = Variant.getVariant("temperate");
        public static final Variant WARM = Variant.getVariant("warm");

        @NotNull
        private static Variant getVariant(@NotNull @KeyPattern.Value String key) {
            return RegistryAccess.registryAccess().getRegistry(RegistryKey.FROG_VARIANT).getOrThrow(Key.key((String)"minecraft", (String)key));
        }

        @Deprecated(since="1.21", forRemoval=true)
        @NotNull
        @ApiStatus.ScheduledForRemoval(inVersion="1.22")
        public static Variant valueOf(@NotNull String name) {
            NamespacedKey key = NamespacedKey.fromString(name.toLowerCase(Locale.ROOT));
            Variant variant = key == null ? null : RegistryAccess.registryAccess().getRegistry(RegistryKey.FROG_VARIANT).get(key);
            Preconditions.checkArgument((variant != null ? 1 : 0) != 0, (String)"No frog variant found with the name %s", (Object)name);
            return variant;
        }

        @Deprecated(since="1.21", forRemoval=true)
        @NotNull
        @ApiStatus.ScheduledForRemoval(inVersion="1.22")
        public static Variant[] values() {
            return (Variant[])RegistryAccess.registryAccess().getRegistry(RegistryKey.FROG_VARIANT).stream().toArray(Variant[]::new);
        }
    }
}

