/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.entity;

import com.google.common.base.Preconditions;
import io.papermc.paper.entity.Shearable;
import io.papermc.paper.world.WeatheringCopperState;
import org.bukkit.entity.Golem;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Range;
import org.jspecify.annotations.NullMarked;

@NullMarked
public interface CopperGolem
extends Golem,
Shearable {
    public WeatheringCopperState getWeatheringState();

    public void setWeatheringState(WeatheringCopperState var1);

    public State getGolemState();

    public void setGolemState(State var1);

    public Oxidizing getOxidizing();

    public void setOxidizing(Oxidizing var1);

    @NullMarked
    public static enum State {
        IDLE,
        GETTING_ITEM,
        GETTING_NO_ITEM,
        DROPPING_ITEM,
        DROPPING_NO_ITEM;

    }

    public static sealed interface Oxidizing {
        public static Oxidizing waxed() {
            return Waxed.INSTANCE;
        }

        public static Oxidizing unset() {
            return Unset.INSTANCE;
        }

        public static AtTime atTime(@Range(from=0L, to=0x7FFFFFFFFFFFFFFFL) long time) {
            Preconditions.checkArgument((time >= 0L ? 1 : 0) != 0, (Object)"time must be non-negative");
            return new AtTimeImpl(time);
        }

        public static final class Waxed
        implements Oxidizing {
            private static final Waxed INSTANCE = new Waxed();

            private Waxed() {
            }
        }

        public static final class Unset
        implements Oxidizing {
            private static final Unset INSTANCE = new Unset();

            private Unset() {
            }
        }

        @ApiStatus.Internal
        public record AtTimeImpl(long time) implements AtTime
        {
        }

        public static sealed interface AtTime
        extends Oxidizing
        permits AtTimeImpl {
            public @Range(from=0L, to=0x7FFFFFFFFFFFFFFFL) long time();
        }
    }
}

