/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.entity;

import com.google.common.base.Preconditions;
import io.papermc.paper.entity.CollarColorable;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import java.util.Locale;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.key.KeyPattern;
import org.bukkit.DyeColor;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Sittable;
import org.bukkit.entity.Tameable;
import org.bukkit.util.OldEnum;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public interface Cat
extends Tameable,
Sittable,
CollarColorable {
    @NotNull
    public Type getCatType();

    public void setCatType(@NotNull Type var1);

    @Override
    @NotNull
    public DyeColor getCollarColor();

    @Override
    public void setCollarColor(@NotNull DyeColor var1);

    public void setLyingDown(boolean var1);

    public boolean isLyingDown();

    public void setHeadUp(boolean var1);

    public boolean isHeadUp();

    public static interface Type
    extends OldEnum<Type>,
    Keyed {
        public static final Type ALL_BLACK = Type.getType("all_black");
        public static final Type BLACK = Type.getType("black");
        public static final Type BRITISH_SHORTHAIR = Type.getType("british_shorthair");
        public static final Type CALICO = Type.getType("calico");
        public static final Type JELLIE = Type.getType("jellie");
        public static final Type PERSIAN = Type.getType("persian");
        public static final Type RAGDOLL = Type.getType("ragdoll");
        public static final Type RED = Type.getType("red");
        public static final Type SIAMESE = Type.getType("siamese");
        public static final Type TABBY = Type.getType("tabby");
        public static final Type WHITE = Type.getType("white");

        @NotNull
        private static Type getType(@NotNull @KeyPattern.Value String key) {
            return RegistryAccess.registryAccess().getRegistry(RegistryKey.CAT_VARIANT).getOrThrow(Key.key((String)"minecraft", (String)key));
        }

        @Deprecated(since="1.21", forRemoval=true)
        @NotNull
        @ApiStatus.ScheduledForRemoval(inVersion="1.22")
        public static Type valueOf(@NotNull String name) {
            NamespacedKey key = NamespacedKey.fromString(name.toLowerCase(Locale.ROOT));
            Type type = key == null ? null : RegistryAccess.registryAccess().getRegistry(RegistryKey.CAT_VARIANT).get(key);
            Preconditions.checkArgument((type != null ? 1 : 0) != 0, (String)"No cat type found with the name %s", (Object)name);
            return type;
        }

        @Deprecated(since="1.21", forRemoval=true)
        @NotNull
        @ApiStatus.ScheduledForRemoval(inVersion="1.22")
        public static Type[] values() {
            return (Type[])RegistryAccess.registryAccess().getRegistry(RegistryKey.CAT_VARIANT).stream().toArray(Type[]::new);
        }
    }
}

