/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit;

import com.google.common.base.Preconditions;
import io.papermc.paper.block.fluid.FluidData;
import io.papermc.paper.math.Position;
import io.papermc.paper.world.MoonPhase;
import io.papermc.paper.world.flag.FeatureFlagSetHolder;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.bukkit.HeightMap;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.TreeType;
import org.bukkit.block.Biome;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.util.BoundingBox;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface RegionAccessor
extends Keyed,
FeatureFlagSetHolder {
    @NotNull
    default public Biome getBiome(@NotNull Location location) {
        return this.getBiome(location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    @NotNull
    public Biome getBiome(int var1, int var2, int var3);

    @NotNull
    public Biome getComputedBiome(int var1, int var2, int var3);

    default public void setBiome(@NotNull Location location, @NotNull Biome biome) {
        this.setBiome(location.getBlockX(), location.getBlockY(), location.getBlockZ(), biome);
    }

    public void setBiome(int var1, int var2, int var3, @NotNull Biome var4);

    @NotNull
    default public BlockState getBlockState(@NotNull Location location) {
        return this.getBlockState(location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    @NotNull
    public BlockState getBlockState(int var1, int var2, int var3);

    @NotNull
    public FluidData getFluidData(int var1, int var2, int var3);

    @NotNull
    default public FluidData getFluidData(@NotNull Position position) {
        return this.getFluidData(position.blockX(), position.blockY(), position.blockZ());
    }

    @NotNull
    default public FluidData getFluidData(@NotNull Location location) {
        return this.getFluidData(location.blockX(), location.blockY(), location.blockZ());
    }

    @NotNull
    default public BlockData getBlockData(@NotNull Location location) {
        return this.getBlockData(location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    @NotNull
    public BlockData getBlockData(int var1, int var2, int var3);

    @NotNull
    default public Material getType(@NotNull Location location) {
        return this.getType(location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    @NotNull
    public Material getType(int var1, int var2, int var3);

    default public void setBlockData(@NotNull Location location, @NotNull BlockData blockData) {
        this.setBlockData(location.getBlockX(), location.getBlockY(), location.getBlockZ(), blockData);
    }

    public void setBlockData(int var1, int var2, int var3, @NotNull BlockData var4);

    default public void setType(@NotNull Location location, @NotNull Material material) {
        this.setType(location.getBlockX(), location.getBlockY(), location.getBlockZ(), material);
    }

    default public void setType(int x, int y, int z, @NotNull Material material) {
        this.setBlockData(x, y, z, material.createBlockData());
    }

    public boolean generateTree(@NotNull Location var1, @NotNull Random var2, @NotNull TreeType var3);

    public boolean generateTree(@NotNull Location var1, @NotNull Random var2, @NotNull TreeType var3, @Nullable Consumer<? super BlockState> var4);

    public boolean generateTree(@NotNull Location var1, @NotNull Random var2, @NotNull TreeType var3, @Nullable Predicate<? super BlockState> var4);

    @NotNull
    default public Entity spawnEntity(@NotNull Location location, @NotNull EntityType type) {
        return this.spawn(location, type.getEntityClass());
    }

    @NotNull
    public Entity spawnEntity(@NotNull Location var1, @NotNull EntityType var2, boolean var3);

    @NotNull
    public List<Entity> getEntities();

    @NotNull
    public List<LivingEntity> getLivingEntities();

    @NotNull
    public <T extends Entity> Collection<T> getEntitiesByClass(@NotNull Class<T> var1);

    @NotNull
    public Collection<Entity> getEntitiesByClasses(Class<?> ... var1);

    @NotNull
    public <T extends Entity> T createEntity(@NotNull Location var1, @NotNull Class<T> var2);

    @NotNull
    default public <T extends Entity> T spawn(@NotNull Location location, @NotNull Class<T> clazz) throws IllegalArgumentException {
        return this.spawn(location, clazz, null, CreatureSpawnEvent.SpawnReason.CUSTOM);
    }

    @NotNull
    default public <T extends Entity> T spawn(@NotNull Location location, @NotNull Class<T> clazz, @Nullable Consumer<? super T> function) throws IllegalArgumentException {
        return this.spawn(location, clazz, CreatureSpawnEvent.SpawnReason.CUSTOM, function);
    }

    @NotNull
    default public <T extends Entity> T spawn(@NotNull Location location, @NotNull Class<T> clazz,  @NotNull CreatureSpawnEvent.SpawnReason reason) throws IllegalArgumentException {
        return this.spawn(location, clazz, reason, null);
    }

    @NotNull
    default public <T extends Entity> T spawn(@NotNull Location location, @NotNull Class<T> clazz,  @NotNull CreatureSpawnEvent.SpawnReason reason, @Nullable Consumer<? super T> function) throws IllegalArgumentException {
        return this.spawn(location, clazz, function, reason);
    }

    @NotNull
    default public Entity spawnEntity(@NotNull Location loc, @NotNull EntityType type,  @NotNull CreatureSpawnEvent.SpawnReason reason) {
        Preconditions.checkArgument((type.getEntityClass() != null ? 1 : 0) != 0, (String)"%s is not a valid EntityType, must have an entity class", (Object)type);
        return this.spawn(loc, type.getEntityClass(), reason, null);
    }

    @NotNull
    default public Entity spawnEntity(@NotNull Location loc, @NotNull EntityType type,  @NotNull CreatureSpawnEvent.SpawnReason reason, @Nullable Consumer<? super Entity> function) {
        Preconditions.checkArgument((type.getEntityClass() != null ? 1 : 0) != 0, (String)"%s is not a valid EntityType, must have an entity class", (Object)type);
        return this.spawn(loc, type.getEntityClass(), reason, function);
    }

    @NotNull
    public <T extends Entity> T spawn(@NotNull Location var1, @NotNull Class<T> var2, @Nullable Consumer<? super T> var3,  @NotNull CreatureSpawnEvent.SpawnReason var4) throws IllegalArgumentException;

    @NotNull
    public <T extends Entity> T spawn(@NotNull Location var1, @NotNull Class<T> var2, boolean var3, @Nullable Consumer<? super T> var4) throws IllegalArgumentException;

    public int getHighestBlockYAt(int var1, int var2);

    public int getHighestBlockYAt(@NotNull Location var1);

    public int getHighestBlockYAt(int var1, int var2, @NotNull HeightMap var3);

    public int getHighestBlockYAt(@NotNull Location var1, @NotNull HeightMap var2);

    @NotNull
    public <T extends Entity> T addEntity(@NotNull T var1);

    @NotNull
    public MoonPhase getMoonPhase();

    @Override
    @NotNull
    public NamespacedKey getKey();

    public boolean lineOfSightExists(@NotNull Location var1, @NotNull Location var2);

    public boolean hasCollisionsIn(@NotNull BoundingBox var1);
}

