/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit;

import com.google.common.base.Preconditions;
import io.papermc.paper.registry.RegistryKey;
import java.util.Locale;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.key.KeyPattern;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.util.OldEnum;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public interface Fluid
extends OldEnum<Fluid>,
Keyed {
    public static final Fluid EMPTY = Fluid.getFluid("empty");
    public static final Fluid FLOWING_LAVA = Fluid.getFluid("flowing_lava");
    public static final Fluid FLOWING_WATER = Fluid.getFluid("flowing_water");
    public static final Fluid LAVA = Fluid.getFluid("lava");
    public static final Fluid WATER = Fluid.getFluid("water");

    @NotNull
    private static Fluid getFluid(@NotNull @KeyPattern.Value String key) {
        return Registry.FLUID.getOrThrow(Key.key((String)"minecraft", (String)key));
    }

    @Deprecated(since="1.21.3", forRemoval=true)
    @NotNull
    @ApiStatus.ScheduledForRemoval(inVersion="1.22")
    public static Fluid valueOf(@NotNull String name) {
        NamespacedKey key = NamespacedKey.fromString(name.toLowerCase(Locale.ROOT));
        Fluid fluid = key == null ? null : Bukkit.getUnsafe().get(RegistryKey.FLUID, key);
        Preconditions.checkArgument((fluid != null ? 1 : 0) != 0, (String)"No fluid found with the name %s", (Object)name);
        return fluid;
    }

    @Deprecated(since="1.21.3", forRemoval=true)
    @NotNull
    @ApiStatus.ScheduledForRemoval(inVersion="1.22")
    public static Fluid[] values() {
        return (Fluid[])Registry.FLUID.stream().toArray(Fluid[]::new);
    }
}

