/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.advancement;

import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.translation.Translatable;
import net.kyori.adventure.util.Index;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public interface AdvancementDisplay {
    public Frame frame();

    public Component title();

    public Component description();

    public ItemStack icon();

    public boolean doesShowToast();

    public boolean doesAnnounceToChat();

    public boolean isHidden();

    public @Nullable NamespacedKey backgroundPath();

    public Component displayName();

    public static enum Frame implements Translatable
    {
        CHALLENGE("challenge", (TextColor)NamedTextColor.DARK_PURPLE),
        GOAL("goal", (TextColor)NamedTextColor.GREEN),
        TASK("task", (TextColor)NamedTextColor.GREEN);

        public static final Index<String, Frame> NAMES;
        private final String name;
        private final TextColor color;

        private Frame(String name, TextColor color) {
            this.name = name;
            this.color = color;
        }

        public TextColor color() {
            return this.color;
        }

        public String translationKey() {
            return "advancements.toast." + this.name;
        }

        static {
            NAMES = Index.create(Frame.class, frame -> frame.name);
        }
    }
}

