/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.entity;

import java.util.List;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public interface Pathfinder {
    public Mob getEntity();

    public void stopPathfinding();

    public boolean hasPath();

    public @Nullable PathResult getCurrentPath();

    public @Nullable PathResult findPath(Location var1);

    default public @Nullable PathResult findPath(LivingEntity target) {
        return this.findPath((Entity)target);
    }

    public @Nullable PathResult findPath(Entity var1);

    default public boolean moveTo(Location loc) {
        return this.moveTo(loc, 1.0);
    }

    default public boolean moveTo(Location loc, double speed) {
        PathResult path = this.findPath(loc);
        return path != null && this.moveTo(path, speed);
    }

    default public boolean moveTo(LivingEntity target) {
        return this.moveTo(target, 1.0);
    }

    default public boolean moveTo(LivingEntity target, double speed) {
        return this.moveTo((Entity)target, speed);
    }

    default public boolean moveTo(Entity target) {
        return this.moveTo(target, 1.0);
    }

    default public boolean moveTo(Entity target, double speed) {
        PathResult path = this.findPath(target);
        return path != null && this.moveTo(path, speed);
    }

    default public boolean moveTo(PathResult path) {
        return this.moveTo(path, 1.0);
    }

    public boolean moveTo(PathResult var1, double var2);

    public boolean canOpenDoors();

    public void setCanOpenDoors(boolean var1);

    public boolean canPassDoors();

    public void setCanPassDoors(boolean var1);

    public boolean canFloat();

    public void setCanFloat(boolean var1);

    public static interface PathResult {
        public List<Location> getPoints();

        public int getNextPointIndex();

        public @Nullable Location getNextPoint();

        public @Nullable Location getFinalPoint();

        public boolean canReachFinalPoint();
    }
}

