/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.plugin;

import com.google.common.base.Preconditions;
import io.papermc.paper.event.executor.EventExecutorFactory;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.event.EventException;
import org.bukkit.event.Listener;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public interface EventExecutor {
    public void execute(@NotNull Listener var1, @NotNull Event var2) throws EventException;

    @NotNull
    public static EventExecutor create(@NotNull Method m, @NotNull Class<? extends Event> eventClass) {
        JavaPlugin plugin;
        Preconditions.checkNotNull((Object)m, (Object)"Null method");
        Preconditions.checkArgument((m.getParameterCount() != 0 ? 1 : 0) != 0, (String)"Incorrect number of arguments %s", (int)m.getParameterCount());
        Preconditions.checkArgument((m.getParameterTypes()[0] == eventClass ? 1 : 0) != 0, (String)"First parameter %s doesn't match event class %s", m.getParameterTypes()[0], eventClass);
        if (m.getReturnType() != Void.TYPE) {
            plugin = JavaPlugin.getProvidingPlugin(m.getDeclaringClass());
            Bukkit.getLogger().warning("@EventHandler method " + m.getDeclaringClass().getName() + (Modifier.isStatic(m.getModifiers()) ? (char)'.' : '#') + m.getName() + " returns non-void type " + m.getReturnType().getName() + ". This is unsupported behavior and will no longer work in a future version of Paper. This should be reported to the developers of " + plugin.getPluginMeta().getDisplayName() + " (" + String.join((CharSequence)",", plugin.getPluginMeta().getAuthors()) + ")");
        }
        if (!m.trySetAccessible()) {
            plugin = JavaPlugin.getProvidingPlugin(m.getDeclaringClass());
            throw new AssertionError((Object)("@EventHandler method " + m.getDeclaringClass().getName() + (Modifier.isStatic(m.getModifiers()) ? (char)'.' : '#') + m.getName() + " is not accessible. This should be reported to the developers of " + plugin.getDescription().getName() + " (" + String.join((CharSequence)",", plugin.getDescription().getAuthors()) + ")"));
        }
        return EventExecutorFactory.create(m, eventClass);
    }
}

