/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.event.block;

import com.google.common.base.Preconditions;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;
import org.bukkit.event.block.BlockEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class BlockDamageEvent
extends BlockEvent
implements Cancellable {
    private static final HandlerList HANDLER_LIST = new HandlerList();
    private final BlockFace blockFace;
    private final ItemStack itemInHand;
    private final Player player;
    private boolean instaBreak;
    private boolean cancelled;

    @Deprecated(forRemoval=true)
    @ApiStatus.Internal
    public BlockDamageEvent(@NotNull Player player, @NotNull Block block, @NotNull ItemStack itemInHand, boolean instaBreak) {
        this(player, block, null, itemInHand, instaBreak);
    }

    @ApiStatus.Internal
    public BlockDamageEvent(@NotNull Player player, @NotNull Block block, @NotNull BlockFace blockFace, @NotNull ItemStack itemInHand, boolean instaBreak) {
        super(block);
        this.instaBreak = instaBreak;
        this.blockFace = blockFace;
        this.itemInHand = itemInHand;
        this.player = player;
    }

    @NotNull
    public Player getPlayer() {
        return this.player;
    }

    public boolean getInstaBreak() {
        return this.instaBreak;
    }

    public void setInstaBreak(boolean instaBreak) {
        this.instaBreak = instaBreak;
    }

    @NotNull
    public ItemStack getItemInHand() {
        return this.itemInHand;
    }

    @NotNull
    public BlockFace getBlockFace() {
        Preconditions.checkState((this.blockFace != null ? 1 : 0) != 0, (Object)"BlockFace is not available for this event, most likely due to a bad constructor call by a plugin");
        return this.blockFace;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }

    @Override
    @NotNull
    public HandlerList getHandlers() {
        return HANDLER_LIST;
    }

    @NotNull
    public static HandlerList getHandlerList() {
        return HANDLER_LIST;
    }
}

