/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.datacomponent.item;

import io.papermc.paper.datacomponent.DataComponentBuilder;
import io.papermc.paper.datacomponent.item.ItemComponentTypesBridge;
import io.papermc.paper.text.Filtered;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import org.checkerframework.common.value.qual.IntRange;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Unmodifiable;
import org.jspecify.annotations.NullMarked;

@NullMarked
@ApiStatus.Experimental
@ApiStatus.NonExtendable
public interface WrittenBookContent {
    @Contract(value="_, _ -> new", pure=true)
    public static Builder writtenBookContent(String title, String author) {
        return WrittenBookContent.writtenBookContent(Filtered.of(title, null), author);
    }

    @Contract(value="_, _ -> new", pure=true)
    public static Builder writtenBookContent(Filtered<String> title, String author) {
        return ItemComponentTypesBridge.bridge().writtenBookContent(title, author);
    }

    @Contract(pure=true)
    public Filtered<String> title();

    @Contract(pure=true)
    public String author();

    @Contract(pure=true)
    public @IntRange(from=0L, to=3L) int generation();

    @Contract(pure=true)
    public @Unmodifiable List<Filtered<Component>> pages();

    @Contract(pure=true)
    public boolean resolved();

    @ApiStatus.Experimental
    @ApiStatus.NonExtendable
    public static interface Builder
    extends DataComponentBuilder<WrittenBookContent> {
        @Contract(value="_ -> this", mutates="this")
        public Builder title(String var1);

        @Contract(value="_ -> this", mutates="this")
        public Builder filteredTitle(Filtered<String> var1);

        @Contract(value="_ -> this", mutates="this")
        public Builder author(String var1);

        @Contract(value="_ -> this", mutates="this")
        public Builder generation(@IntRange(from=0L, to=3L) int var1);

        @Contract(value="_ -> this", mutates="this")
        public Builder resolved(boolean var1);

        @Contract(value="_ -> this", mutates="this")
        public Builder addPage(ComponentLike var1);

        @Contract(value="_ -> this", mutates="this")
        public Builder addPages(List<? extends ComponentLike> var1);

        @Contract(value="_ -> this", mutates="this")
        public Builder addFilteredPage(Filtered<? extends ComponentLike> var1);

        @Contract(value="_ -> this", mutates="this")
        public Builder addFilteredPages(List<Filtered<? extends ComponentLike>> var1);
    }
}

