/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.inventory;

import com.google.common.base.Preconditions;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.set.RegistryKeySet;
import io.papermc.paper.registry.set.RegistrySet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.inventory.EmptyRecipeChoice;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.ItemType;
import org.bukkit.inventory.ItemTypeRecipeChoiceImpl;
import org.bukkit.material.MaterialData;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jspecify.annotations.NullMarked;

@NullMarked
@ApiStatus.NonExtendable
public interface RecipeChoice
extends Predicate<ItemStack>,
Cloneable {
    public static RecipeChoice empty() {
        return EmptyRecipeChoice.INSTANCE;
    }

    @Contract(pure=true, value="_, _ -> new")
    public static ItemTypeChoice itemType(ItemType itemType, ItemType ... itemTypes) {
        ArrayList<ItemType> types = new ArrayList<ItemType>();
        types.add(itemType);
        types.addAll(Arrays.asList(itemTypes));
        return RecipeChoice.itemType(RegistrySet.keySetFromValues(RegistryKey.ITEM, types));
    }

    @Contract(pure=true, value="_ -> new")
    public static ItemTypeChoice itemType(RegistryKeySet<ItemType> itemTypes) {
        return new ItemTypeRecipeChoiceImpl(itemTypes);
    }

    @Deprecated(since="1.13.1")
    public ItemStack getItemStack();

    public RecipeChoice clone();

    @Override
    public boolean test(ItemStack var1);

    @ApiStatus.Internal
    default public RecipeChoice validate(boolean allowEmptyRecipes) {
        return this;
    }

    public static sealed interface ItemTypeChoice
    extends RecipeChoice
    permits ItemTypeRecipeChoiceImpl {
        public RegistryKeySet<ItemType> itemTypes();
    }

    public static final class ExactChoice
    implements RecipeChoice {
        private List<ItemStack> choices;

        public ExactChoice(ItemStack stack) {
            this(Arrays.asList(stack));
        }

        public ExactChoice(ItemStack ... stacks) {
            this(Arrays.asList(stacks));
        }

        public ExactChoice(List<ItemStack> choices) {
            Preconditions.checkArgument((choices != null ? 1 : 0) != 0, (Object)"choices");
            Preconditions.checkArgument((!choices.isEmpty() ? 1 : 0) != 0, (Object)"Must have at least one choice");
            for (ItemStack choice : choices) {
                Preconditions.checkArgument((choice != null ? 1 : 0) != 0, (Object)"Cannot have null choice");
                Preconditions.checkArgument((!choice.getType().isAir() ? 1 : 0) != 0, (Object)"Cannot have empty/air choice");
            }
            this.choices = new ArrayList<ItemStack>(choices);
        }

        @Override
        @Deprecated(since="1.13.1")
        public ItemStack getItemStack() {
            return this.choices.get(0).clone();
        }

        public List<ItemStack> getChoices() {
            return Collections.unmodifiableList(this.choices);
        }

        @Override
        public ExactChoice clone() {
            try {
                ExactChoice clone = (ExactChoice)super.clone();
                clone.choices = new ArrayList<ItemStack>(this.choices.size());
                for (ItemStack choice : this.choices) {
                    clone.choices.add(choice.clone());
                }
                return clone;
            }
            catch (CloneNotSupportedException ex) {
                throw new AssertionError((Object)ex);
            }
        }

        @Override
        public boolean test(ItemStack t) {
            for (ItemStack match : this.choices) {
                if (!t.isSimilar(match)) continue;
                return true;
            }
            return false;
        }

        public int hashCode() {
            int hash = 7;
            hash = 41 * hash + Objects.hashCode(this.choices);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ExactChoice other = (ExactChoice)obj;
            return Objects.equals(this.choices, other.choices);
        }

        public String toString() {
            return "ExactChoice{choices=" + String.valueOf(this.choices) + "}";
        }

        @Override
        public RecipeChoice validate(boolean allowEmptyRecipes) {
            if (this.choices.stream().anyMatch(s -> s.getType().isAir())) {
                throw new IllegalArgumentException("RecipeChoice.ExactChoice cannot contain air");
            }
            return this;
        }
    }

    @ApiStatus.Obsolete(since="1.21.11")
    public static sealed class MaterialChoice
    implements RecipeChoice
    permits ItemTypeRecipeChoiceImpl {
        private List<Material> choices;

        protected MaterialChoice() {
        }

        public MaterialChoice(Material choice) {
            this(Arrays.asList(choice));
        }

        public MaterialChoice(Material ... choices) {
            this(Arrays.asList(choices));
        }

        public MaterialChoice(Tag<Material> choices) {
            this(new ArrayList<Material>(Objects.requireNonNull(choices, "Cannot create a material choice with null tag").getValues()));
        }

        public MaterialChoice(List<Material> choices) {
            Preconditions.checkArgument((choices != null ? 1 : 0) != 0, (Object)"choices");
            Preconditions.checkArgument((!choices.isEmpty() ? 1 : 0) != 0, (Object)"Must have at least one choice");
            this.choices = new ArrayList<Material>(choices.size());
            for (Material choice : choices) {
                Preconditions.checkArgument((choice != null ? 1 : 0) != 0, (Object)"Cannot have null choice");
                if (choice.isLegacy()) {
                    choice = Bukkit.getUnsafe().fromLegacy(new MaterialData(choice, 0), true);
                }
                Preconditions.checkArgument((!choice.isAir() ? 1 : 0) != 0, (Object)"Cannot have empty/air choice");
                Preconditions.checkArgument((boolean)choice.isItem(), (String)"Cannot have non-item choice %s", (Object)choice);
                this.choices.add(choice);
            }
        }

        @Override
        public boolean test(ItemStack t) {
            for (Material match : this.choices) {
                if (t.getType() != match) continue;
                return true;
            }
            return false;
        }

        @Override
        @Deprecated(since="1.13.1")
        public ItemStack getItemStack() {
            ItemStack stack = new ItemStack(this.choices.get(0));
            if (this.choices.size() > 1) {
                stack.setDurability((short)Short.MAX_VALUE);
            }
            return stack;
        }

        public List<Material> getChoices() {
            return Collections.unmodifiableList(this.choices);
        }

        @Override
        public MaterialChoice clone() {
            try {
                MaterialChoice clone = (MaterialChoice)super.clone();
                clone.choices = new ArrayList<Material>(this.choices);
                return clone;
            }
            catch (CloneNotSupportedException ex) {
                throw new AssertionError((Object)ex);
            }
        }

        public int hashCode() {
            int hash = 3;
            hash = 37 * hash + Objects.hashCode(this.choices);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MaterialChoice other = (MaterialChoice)obj;
            return Objects.equals(this.choices, other.choices);
        }

        public String toString() {
            return "MaterialChoice{choices=" + String.valueOf(this.choices) + "}";
        }

        @Override
        public RecipeChoice validate(boolean allowEmptyRecipes) {
            if (this.choices.stream().anyMatch(Material::isAir)) {
                throw new IllegalArgumentException("RecipeChoice.MaterialChoice cannot contain air");
            }
            return this;
        }
    }
}

