/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.registry.data;

import io.papermc.paper.registry.RegistryBuilder;
import io.papermc.paper.registry.set.RegistryKeySet;
import java.util.List;
import net.kyori.adventure.text.Component;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.EquipmentSlotGroup;
import org.bukkit.inventory.ItemType;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Range;
import org.jetbrains.annotations.Unmodifiable;
import org.jspecify.annotations.Nullable;

@ApiStatus.Experimental
@ApiStatus.NonExtendable
public interface EnchantmentRegistryEntry {
    public Component description();

    public RegistryKeySet<ItemType> supportedItems();

    public @Nullable RegistryKeySet<ItemType> primaryItems();

    public @Range(from=1L, to=1024L) int weight();

    public @Range(from=1L, to=255L) int maxLevel();

    public EnchantmentCost minimumCost();

    public EnchantmentCost maximumCost();

    public @Range(from=0L, to=0x7FFFFFFFL) int anvilCost();

    public @Unmodifiable List<EquipmentSlotGroup> activeSlots();

    public RegistryKeySet<Enchantment> exclusiveWith();

    public static interface EnchantmentCost {
        public int baseCost();

        public int additionalPerLevelCost();

        @Contract(value="_,_ -> new", pure=true)
        public static EnchantmentCost of(int baseCost, int additionalPerLevelCost) {
            record Impl(int baseCost, int additionalPerLevelCost) implements EnchantmentCost
            {
            }
            return new Impl(baseCost, additionalPerLevelCost);
        }
    }

    @ApiStatus.Experimental
    @ApiStatus.NonExtendable
    public static interface Builder
    extends EnchantmentRegistryEntry,
    RegistryBuilder<Enchantment> {
        @Contract(value="_ -> this", mutates="this")
        public Builder description(Component var1);

        @Contract(value="_ -> this", mutates="this")
        public Builder supportedItems(RegistryKeySet<ItemType> var1);

        @Contract(value="_ -> this", mutates="this")
        public Builder primaryItems(@Nullable RegistryKeySet<ItemType> var1);

        @Contract(value="_ -> this", mutates="this")
        public Builder weight(@Range(from=1L, to=1024L) int var1);

        @Contract(value="_ -> this", mutates="this")
        public Builder maxLevel(@Range(from=1L, to=255L) int var1);

        @Contract(value="_ -> this", mutates="this")
        public Builder minimumCost(EnchantmentCost var1);

        @Contract(value="_ -> this", mutates="this")
        public Builder maximumCost(EnchantmentCost var1);

        @Contract(value="_ -> this", mutates="this")
        public Builder anvilCost(@Range(from=0L, to=0x7FFFFFFFL) int var1);

        @Contract(value="_ -> this", mutates="this")
        default public Builder activeSlots(EquipmentSlotGroup ... activeSlots) {
            return this.activeSlots(List.of(activeSlots));
        }

        @Contract(value="_ -> this", mutates="this")
        public Builder activeSlots(Iterable<EquipmentSlotGroup> var1);

        @Contract(value="_ -> this", mutates="this")
        public Builder exclusiveWith(RegistryKeySet<Enchantment> var1);
    }
}

