/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.inventory;

import com.google.common.base.Preconditions;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.TypedKey;
import io.papermc.paper.registry.keys.ItemTypeKeys;
import io.papermc.paper.registry.set.RegistryKeySet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.bukkit.Material;
import org.bukkit.Registry;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.ItemType;
import org.bukkit.inventory.RecipeChoice;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
final class ItemTypeRecipeChoiceImpl
extends RecipeChoice.MaterialChoice
implements RecipeChoice.ItemTypeChoice {
    private final RegistryKeySet<ItemType> itemTypes;
    private @Nullable List<Material> legacyChoices;

    ItemTypeRecipeChoiceImpl(RegistryKeySet<ItemType> itemTypes) {
        Preconditions.checkArgument((!itemTypes.isEmpty() ? 1 : 0) != 0, (Object)"ItemTypeChoice cannot be empty");
        Preconditions.checkArgument((!itemTypes.contains(ItemTypeKeys.AIR) ? 1 : 0) != 0, (Object)"ItemTypeChoice cannot contain minecraft:air");
        this.itemTypes = itemTypes;
    }

    @Override
    public ItemStack getItemStack() {
        throw new UnsupportedOperationException("ItemTypeChoice does not support this");
    }

    @Override
    public ItemTypeRecipeChoiceImpl clone() {
        return new ItemTypeRecipeChoiceImpl(this.itemTypes);
    }

    @Override
    public boolean test(ItemStack itemStack) {
        return this.itemTypes.contains(RegistryKey.ITEM.typedKey(itemStack.getType().key()));
    }

    @Override
    public RecipeChoice validate(boolean allowEmptyRecipes) {
        Preconditions.checkArgument((!this.itemTypes.contains(ItemTypeKeys.AIR) ? 1 : 0) != 0, (Object)"ItemTypeChoice cannot contain minecraft:air");
        return this;
    }

    @Override
    public RegistryKeySet<ItemType> itemTypes() {
        return this.itemTypes;
    }

    @Override
    public List<Material> getChoices() {
        if (this.legacyChoices == null) {
            ArrayList<Material> choices = new ArrayList<Material>();
            for (TypedKey<ItemType> typedKey : this.itemTypes) {
                choices.add(Registry.MATERIAL.getOrThrow(typedKey));
            }
            this.legacyChoices = Collections.unmodifiableList(choices);
        }
        return this.legacyChoices;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ItemTypeRecipeChoiceImpl that = (ItemTypeRecipeChoiceImpl)obj;
        return Objects.equals(this.itemTypes, that.itemTypes);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.itemTypes);
    }

    @Override
    public String toString() {
        return "ItemTypeRecipeChoiceImpl[itemTypes=" + String.valueOf(this.itemTypes) + "]";
    }
}

