/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.event.server;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TabCompleteEvent
extends Event
implements Cancellable {
    private static final HandlerList HANDLER_LIST = new HandlerList();
    private final CommandSender sender;
    private final String buffer;
    private final boolean isCommand;
    private final Location location;
    private List<String> completions;
    private boolean cancelled;

    @ApiStatus.Internal
    public TabCompleteEvent(@NotNull CommandSender sender, @NotNull String buffer, @NotNull List<String> completions) {
        this(sender, buffer, completions, sender instanceof ConsoleCommandSender || buffer.startsWith("/"), null);
    }

    @ApiStatus.Internal
    public TabCompleteEvent(@NotNull CommandSender sender, @NotNull String buffer, @NotNull List<String> completions, boolean isCommand, @Nullable Location location) {
        this.sender = sender;
        this.buffer = buffer;
        this.completions = new ArrayList<String>(completions);
        this.isCommand = isCommand;
        this.location = location;
    }

    @NotNull
    public CommandSender getSender() {
        return this.sender;
    }

    @NotNull
    public String getBuffer() {
        return this.buffer;
    }

    @NotNull
    public List<String> getCompletions() {
        return this.completions;
    }

    public void setCompletions(@NotNull List<String> completions) {
        Preconditions.checkArgument((completions != null ? 1 : 0) != 0, (Object)"completions cannot be null");
        this.completions = new ArrayList<String>(completions);
    }

    public boolean isCommand() {
        return this.isCommand;
    }

    @Nullable
    public Location getLocation() {
        return this.location != null ? this.location.clone() : null;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    @Override
    @NotNull
    public HandlerList getHandlers() {
        return HANDLER_LIST;
    }

    @NotNull
    public static HandlerList getHandlerList() {
        return HANDLER_LIST;
    }
}

