/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.datacomponent.item;

import io.papermc.paper.datacomponent.DataComponentBuilder;
import io.papermc.paper.datacomponent.item.ItemComponentTypesBridge;
import net.kyori.adventure.key.Key;
import org.checkerframework.checker.index.qual.NonNegative;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
@ApiStatus.Experimental
@ApiStatus.NonExtendable
public interface KineticWeapon {
    @Contract(value="-> new", pure=true)
    public static Builder kineticWeapon() {
        return ItemComponentTypesBridge.bridge().kineticWeapon();
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public static Condition condition(@NonNegative int maxDurationTicks, float minSpeed, float minRelativeSpeed) {
        return ItemComponentTypesBridge.bridge().kineticWeaponCondition(maxDurationTicks, minSpeed, minRelativeSpeed);
    }

    @Contract(pure=true)
    public @NonNegative int contactCooldownTicks();

    @Contract(pure=true)
    public @NonNegative int delayTicks();

    @Contract(pure=true)
    public @Nullable Condition dismountConditions();

    @Contract(pure=true)
    public @Nullable Condition knockbackConditions();

    @Contract(pure=true)
    public @Nullable Condition damageConditions();

    public float forwardMovement();

    public float damageMultiplier();

    @Contract(pure=true)
    public @Nullable Key sound();

    @Contract(pure=true)
    public @Nullable Key hitSound();

    @ApiStatus.Experimental
    @ApiStatus.NonExtendable
    public static interface Builder
    extends DataComponentBuilder<KineticWeapon> {
        @Contract(value="_ -> this", mutates="this")
        public Builder contactCooldownTicks(@NonNegative int var1);

        @Contract(value="_ -> this", mutates="this")
        public Builder delayTicks(@NonNegative int var1);

        @Contract(value="_ -> this", mutates="this")
        public Builder dismountConditions(@Nullable Condition var1);

        @Contract(value="_ -> this", mutates="this")
        public Builder knockbackConditions(@Nullable Condition var1);

        @Contract(value="_ -> this", mutates="this")
        public Builder damageConditions(@Nullable Condition var1);

        @Contract(value="_ -> this", mutates="this")
        public Builder forwardMovement(float var1);

        @Contract(value="_ -> this", mutates="this")
        public Builder damageMultiplier(float var1);

        @Contract(value="_ -> this", mutates="this")
        public Builder sound(@Nullable Key var1);

        @Contract(value="_ -> this", mutates="this")
        public Builder hitSound(@Nullable Key var1);
    }

    public static interface Condition {
        @Contract(pure=true)
        public @NonNegative int maxDurationTicks();

        @Contract(pure=true)
        public float minSpeed();

        @Contract(pure=true)
        public float minRelativeSpeed();
    }
}

