/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.event.world.border;

import com.google.common.base.Preconditions;
import io.papermc.paper.event.world.border.WorldBorderEvent;
import io.papermc.paper.util.Tick;
import java.time.Duration;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;
import org.checkerframework.checker.index.qual.NonNegative;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Range;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class WorldBorderBoundsChangeEvent
extends WorldBorderEvent
implements Cancellable {
    private static final HandlerList HANDLER_LIST = new HandlerList();
    private Type type;
    private final double oldSize;
    private double newSize;
    private long duration;
    private boolean cancelled;

    @ApiStatus.Internal
    public WorldBorderBoundsChangeEvent(World world, WorldBorder worldBorder, Type type, double oldSize, double newSize, long duration) {
        super(world, worldBorder);
        this.type = type;
        this.oldSize = oldSize;
        this.newSize = newSize;
        this.duration = duration;
    }

    public Type getType() {
        return this.type;
    }

    public double getOldSize() {
        return this.oldSize;
    }

    public double getNewSize() {
        return this.newSize;
    }

    public void setNewSize(double newSize) {
        this.newSize = Math.clamp(newSize, 1.0, this.worldBorder.getMaxSize());
    }

    public @Range(from=0L, to=0x7FFFFFFFL) long getDurationTicks() {
        return this.duration;
    }

    public void setDurationTicks(@Range(from=0L, to=0x7FFFFFFFL) long duration) {
        Preconditions.checkArgument((duration >= 0L && duration <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)"duration must be between 0-%s", (int)Integer.MAX_VALUE);
        this.duration = duration;
        if (this.type == Type.INSTANT_MOVE) {
            this.type = Type.STARTED_MOVE;
        }
    }

    @Deprecated(forRemoval=true, since="1.21.11")
    public @NonNegative long getDuration() {
        return Tick.of(this.getDurationTicks()).toMillis();
    }

    @Deprecated(forRemoval=true, since="1.21.11")
    public void setDuration(@NonNegative long duration) {
        this.setDurationTicks(Tick.tick().fromDuration(Duration.ofMillis(duration)));
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }

    @Override
    public HandlerList getHandlers() {
        return HANDLER_LIST;
    }

    public static HandlerList getHandlerList() {
        return HANDLER_LIST;
    }

    public static enum Type {
        STARTED_MOVE,
        INSTANT_MOVE;

    }
}

