/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.datacomponent.item;

import io.papermc.paper.datacomponent.DataComponentBuilder;
import io.papermc.paper.datacomponent.item.ItemComponentTypesBridge;
import io.papermc.paper.datacomponent.item.attribute.AttributeModifierDisplay;
import java.util.List;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.inventory.EquipmentSlotGroup;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Unmodifiable;
import org.jspecify.annotations.NullMarked;

@NullMarked
@ApiStatus.Experimental
@ApiStatus.NonExtendable
public interface ItemAttributeModifiers {
    @Contract(value="-> new", pure=true)
    public static Builder itemAttributes() {
        return ItemComponentTypesBridge.bridge().modifiers();
    }

    @Contract(pure=true)
    public @Unmodifiable List<Entry> modifiers();

    @ApiStatus.Experimental
    @ApiStatus.NonExtendable
    public static interface Builder
    extends DataComponentBuilder<ItemAttributeModifiers> {
        @Contract(value="_, _ -> this", mutates="this")
        default public Builder addModifier(Attribute attribute, AttributeModifier modifier) {
            return this.addModifier(attribute, modifier, modifier.getSlotGroup());
        }

        @Contract(value="_, _, _ -> this", mutates="this")
        default public Builder addModifier(Attribute attribute, AttributeModifier modifier, EquipmentSlotGroup equipmentSlotGroup) {
            return this.addModifier(attribute, modifier, equipmentSlotGroup, AttributeModifierDisplay.reset());
        }

        @Contract(value="_, _, _ -> this", mutates="this")
        default public Builder addModifier(Attribute attribute, AttributeModifier modifier, AttributeModifierDisplay display) {
            return this.addModifier(attribute, modifier, modifier.getSlotGroup(), display);
        }

        @Contract(value="_, _, _, _ -> this", mutates="this")
        public Builder addModifier(Attribute var1, AttributeModifier var2, EquipmentSlotGroup var3, AttributeModifierDisplay var4);
    }

    @ApiStatus.NonExtendable
    public static interface Entry {
        @Contract(pure=true)
        public Attribute attribute();

        @Contract(pure=true)
        public AttributeModifier modifier();

        default public EquipmentSlotGroup getGroup() {
            return this.modifier().getSlotGroup();
        }

        @Contract(pure=true)
        public AttributeModifierDisplay display();
    }
}

