/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.event.player;

import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Statistic;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.material.MaterialData;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerStatisticIncrementEvent
extends PlayerEvent
implements Cancellable {
    private static final HandlerList HANDLER_LIST = new HandlerList();
    protected final Statistic statistic;
    private final int initialValue;
    private final int newValue;
    private final EntityType entityType;
    private final Material material;
    private boolean cancelled;

    @ApiStatus.Internal
    public PlayerStatisticIncrementEvent(@NotNull Player player, @NotNull Statistic statistic, int initialValue, int newValue) {
        super(player);
        this.statistic = statistic;
        this.initialValue = initialValue;
        this.newValue = newValue;
        this.entityType = null;
        this.material = null;
    }

    @ApiStatus.Internal
    public PlayerStatisticIncrementEvent(@NotNull Player player, @NotNull Statistic statistic, int initialValue, int newValue, @NotNull EntityType entityType) {
        super(player);
        this.statistic = statistic;
        this.initialValue = initialValue;
        this.newValue = newValue;
        this.entityType = entityType;
        this.material = null;
    }

    @ApiStatus.Internal
    public PlayerStatisticIncrementEvent(@NotNull Player player, @NotNull Statistic statistic, int initialValue, int newValue, @NotNull Material material) {
        super(player);
        this.statistic = statistic;
        this.initialValue = initialValue;
        this.newValue = newValue;
        this.entityType = null;
        if (material != null && material.isLegacy()) {
            material = statistic.getType() == Statistic.Type.BLOCK ? Bukkit.getUnsafe().fromLegacy(new MaterialData(material), false) : (statistic.getType() == Statistic.Type.ITEM ? Bukkit.getUnsafe().fromLegacy(new MaterialData(material), true) : Bukkit.getUnsafe().fromLegacy(new MaterialData(material), false));
        }
        this.material = material;
    }

    @NotNull
    public Statistic getStatistic() {
        return this.statistic;
    }

    public int getPreviousValue() {
        return this.initialValue;
    }

    public int getNewValue() {
        return this.newValue;
    }

    @Nullable
    public EntityType getEntityType() {
        return this.entityType;
    }

    @Nullable
    public Material getMaterial() {
        return this.material;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }

    @Override
    @NotNull
    public HandlerList getHandlers() {
        return HANDLER_LIST;
    }

    @NotNull
    public static HandlerList getHandlerList() {
        return HANDLER_LIST;
    }
}

