/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.event.player;

import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;
import org.bukkit.event.player.PlayerEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class PlayerKickEvent
extends PlayerEvent
implements Cancellable {
    private static final HandlerList HANDLER_LIST = new HandlerList();
    private Component kickReason;
    private Component leaveMessage;
    private final Cause cause;
    private boolean cancelled;

    @Deprecated(forRemoval=true)
    @ApiStatus.Internal
    public PlayerKickEvent(@NotNull Player playerKicked, @NotNull String kickReason, @NotNull String leaveMessage) {
        super(playerKicked);
        this.kickReason = LegacyComponentSerializer.legacySection().deserialize(kickReason);
        this.leaveMessage = LegacyComponentSerializer.legacySection().deserialize(leaveMessage);
        this.cause = Cause.UNKNOWN;
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.Internal
    public PlayerKickEvent(@NotNull Player playerKicked, @NotNull Component kickReason, @NotNull Component leaveMessage) {
        super(playerKicked);
        this.kickReason = kickReason;
        this.leaveMessage = leaveMessage;
        this.cause = Cause.UNKNOWN;
    }

    @ApiStatus.Internal
    public PlayerKickEvent(@NotNull Player playerKicked, @NotNull Component kickReason, @NotNull Component leaveMessage, @NotNull Cause cause) {
        super(playerKicked);
        this.kickReason = kickReason;
        this.leaveMessage = leaveMessage;
        this.cause = cause;
    }

    @NotNull
    public Component reason() {
        return this.kickReason;
    }

    public void reason(@NotNull Component kickReason) {
        this.kickReason = kickReason;
    }

    @Deprecated
    @NotNull
    public String getReason() {
        return LegacyComponentSerializer.legacySection().serialize(this.kickReason);
    }

    @Deprecated
    public void setReason(@NotNull String kickReason) {
        this.kickReason = LegacyComponentSerializer.legacySection().deserialize(kickReason);
    }

    @NotNull
    public Component leaveMessage() {
        return this.leaveMessage;
    }

    public void leaveMessage(@NotNull Component leaveMessage) {
        this.leaveMessage = leaveMessage;
    }

    @Deprecated
    @NotNull
    public String getLeaveMessage() {
        return LegacyComponentSerializer.legacySection().serialize(this.leaveMessage);
    }

    @Deprecated
    public void setLeaveMessage(@NotNull String leaveMessage) {
        this.leaveMessage = LegacyComponentSerializer.legacySection().deserialize(leaveMessage);
    }

    @NotNull
    public Cause getCause() {
        return this.cause;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }

    @Override
    @NotNull
    public HandlerList getHandlers() {
        return HANDLER_LIST;
    }

    @NotNull
    public static HandlerList getHandlerList() {
        return HANDLER_LIST;
    }

    public static enum Cause {
        PLUGIN,
        WHITELIST,
        BANNED,
        IP_BANNED,
        KICK_COMMAND,
        FLYING_PLAYER,
        FLYING_VEHICLE,
        TIMEOUT,
        IDLING,
        INVALID_VEHICLE_MOVEMENT,
        INVALID_PLAYER_MOVEMENT,
        INVALID_ENTITY_ATTACKED,
        INVALID_PAYLOAD,
        INVALID_COOKIE,
        SPAM,
        ILLEGAL_ACTION,
        ILLEGAL_CHARACTERS,
        OUT_OF_ORDER_CHAT,
        UNSIGNED_CHAT,
        CHAT_VALIDATION_FAILED,
        EXPIRED_PROFILE_PUBLIC_KEY,
        INVALID_PUBLIC_KEY_SIGNATURE,
        TOO_MANY_PENDING_CHATS,
        SELF_INTERACTION,
        DUPLICATE_LOGIN,
        RESOURCE_PACK_REJECTION,
        RESTART_COMMAND,
        UNKNOWN;

    }
}

