/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.event.player;

import com.destroystokyo.paper.profile.PlayerProfile;
import io.papermc.paper.connection.PlayerLoginConnection;
import java.net.InetAddress;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.event.player.PlayerPreLoginEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class AsyncPlayerPreLoginEvent
extends Event {
    private static final HandlerList HANDLER_LIST = new HandlerList();
    private final InetAddress ipAddress;
    private final InetAddress rawAddress;
    private final String hostname;
    private final boolean transferred;
    private Result result = Result.ALLOWED;
    private Component message = Component.empty();
    private PlayerProfile profile;
    private final PlayerLoginConnection playerLoginConnection;

    @Deprecated(since="1.7.5", forRemoval=true)
    @ApiStatus.Internal
    public AsyncPlayerPreLoginEvent(@NotNull String name, @NotNull InetAddress ipAddress) {
        this(name, ipAddress, null);
    }

    @Deprecated(since="1.20.5", forRemoval=true)
    @ApiStatus.Internal
    public AsyncPlayerPreLoginEvent(@NotNull String name, @NotNull InetAddress ipAddress, @NotNull UUID uniqueId) {
        this(name, ipAddress, uniqueId, false);
    }

    @ApiStatus.Internal
    public AsyncPlayerPreLoginEvent(@NotNull String name, @NotNull InetAddress ipAddress, @NotNull UUID uniqueId, boolean transferred) {
        this(name, ipAddress, uniqueId, transferred, Bukkit.createProfile(uniqueId, name));
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.Internal
    public AsyncPlayerPreLoginEvent(@NotNull String name, @NotNull InetAddress ipAddress, @NotNull UUID uniqueId, boolean transferred, @NotNull PlayerProfile profile) {
        this(name, ipAddress, ipAddress, uniqueId, transferred, profile);
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.Internal
    public AsyncPlayerPreLoginEvent(@NotNull String name, @NotNull InetAddress ipAddress, @NotNull InetAddress rawAddress, @NotNull UUID uniqueId, boolean transferred, @NotNull PlayerProfile profile) {
        this(name, ipAddress, rawAddress, uniqueId, transferred, profile, "", null);
    }

    @ApiStatus.Internal
    public AsyncPlayerPreLoginEvent(@NotNull String name, @NotNull InetAddress ipAddress, @NotNull InetAddress rawAddress, @NotNull UUID uniqueId, boolean transferred, @NotNull PlayerProfile profile, @NotNull String hostname, PlayerLoginConnection playerLoginConnection) {
        super(true);
        this.profile = profile;
        this.ipAddress = ipAddress;
        this.rawAddress = rawAddress;
        this.hostname = hostname;
        this.transferred = transferred;
        this.playerLoginConnection = playerLoginConnection;
    }

    @NotNull
    public Result getLoginResult() {
        return this.result;
    }

    @Deprecated(since="1.3.2")
    @NotNull
    public PlayerPreLoginEvent.Result getResult() {
        return this.result == null ? null : this.result.old();
    }

    public void setLoginResult(@NotNull Result result) {
        this.result = result;
    }

    @Deprecated(since="1.3.2")
    public void setResult(@NotNull PlayerPreLoginEvent.Result result) {
        this.result = result == null ? null : Result.valueOf(result.name());
    }

    @NotNull
    public Component kickMessage() {
        return this.message;
    }

    public void kickMessage(@NotNull Component message) {
        this.message = message;
    }

    public void disallow(@NotNull Result result, @NotNull Component message) {
        this.result = result;
        this.message = message;
    }

    @Deprecated
    public void disallow(@NotNull PlayerPreLoginEvent.Result result, @NotNull Component message) {
        this.result = result == null ? null : Result.valueOf(result.name());
        this.message = message;
    }

    @Deprecated
    @NotNull
    public String getKickMessage() {
        return LegacyComponentSerializer.legacySection().serialize(this.message);
    }

    @Deprecated
    public void setKickMessage(@NotNull String message) {
        this.message = LegacyComponentSerializer.legacySection().deserialize(message);
    }

    public void allow() {
        this.result = Result.ALLOWED;
        this.message = Component.empty();
    }

    @Deprecated
    public void disallow(@NotNull Result result, @NotNull String message) {
        this.result = result;
        this.message = LegacyComponentSerializer.legacySection().deserialize(message);
    }

    @Deprecated(since="1.3.2")
    public void disallow(@NotNull PlayerPreLoginEvent.Result result, @NotNull String message) {
        this.result = result == null ? null : Result.valueOf(result.name());
        this.message = LegacyComponentSerializer.legacySection().deserialize(message);
    }

    @NotNull
    public String getName() {
        return this.profile.getName();
    }

    @NotNull
    public InetAddress getAddress() {
        return this.ipAddress;
    }

    @NotNull
    public UUID getUniqueId() {
        return this.profile.getId();
    }

    @NotNull
    public PlayerProfile getPlayerProfile() {
        return this.profile;
    }

    public void setPlayerProfile(@NotNull PlayerProfile profile) {
        this.profile = profile;
    }

    @NotNull
    public InetAddress getRawAddress() {
        return this.rawAddress;
    }

    @NotNull
    public String getHostname() {
        return this.hostname;
    }

    public boolean isTransferred() {
        return this.transferred;
    }

    @ApiStatus.Experimental
    @NotNull
    public PlayerLoginConnection getConnection() {
        return this.playerLoginConnection;
    }

    @Override
    @NotNull
    public HandlerList getHandlers() {
        return HANDLER_LIST;
    }

    @NotNull
    public static HandlerList getHandlerList() {
        return HANDLER_LIST;
    }

    public static enum Result {
        ALLOWED,
        KICK_FULL,
        KICK_BANNED,
        KICK_WHITELIST,
        KICK_OTHER;


        @Deprecated(since="1.3.2")
        @NotNull
        private PlayerPreLoginEvent.Result old() {
            return PlayerPreLoginEvent.Result.valueOf(this.name());
        }
    }
}

