/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.command.defaults;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.defaults.BukkitCommand;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class ReloadCommand
extends BukkitCommand {
    @ApiStatus.Internal
    public static final String RELOADING_DISABLED_MESSAGE = "A lifecycle event handler has been registered which makes reloading plugins not possible";

    public ReloadCommand(@NotNull String name) {
        super(name);
        this.description = "Reloads the server configuration and plugins";
        this.usageMessage = "/reload [permissions|commands|confirm]";
        this.setPermission("bukkit.command.reload");
        this.setAliases(Arrays.asList("rl"));
    }

    @Override
    public boolean execute(@NotNull CommandSender sender, @NotNull String currentAlias, @NotNull String[] args) {
        block11: {
            boolean confirmed;
            if (!this.testPermission(sender)) {
                return true;
            }
            boolean bl = confirmed = System.getProperty("LetMeReload") != null;
            if (args.length == 1) {
                if (args[0].equalsIgnoreCase("permissions")) {
                    Bukkit.getServer().reloadPermissions();
                    Command.broadcastCommandMessage(sender, (Component)Component.text((String)"Permissions successfully reloaded.", (TextColor)NamedTextColor.GREEN));
                    return true;
                }
                if ("commands".equalsIgnoreCase(args[0])) {
                    if (Bukkit.getServer().reloadCommandAliases()) {
                        Command.broadcastCommandMessage(sender, (Component)Component.text((String)"Command aliases successfully reloaded.", (TextColor)NamedTextColor.GREEN));
                    } else {
                        Command.broadcastCommandMessage(sender, (Component)Component.text((String)"An error occurred while trying to reload command aliases.", (TextColor)NamedTextColor.RED));
                    }
                    return true;
                }
                if ("confirm".equalsIgnoreCase(args[0])) {
                    confirmed = true;
                } else {
                    Command.broadcastCommandMessage(sender, (Component)Component.text((String)("Usage: " + this.usageMessage), (TextColor)NamedTextColor.RED));
                    return true;
                }
            }
            if (!confirmed) {
                Command.broadcastCommandMessage(sender, Component.text((String)"Are you sure you wish to reload your server? This command will be removed soon. Doing so may cause bugs and memory leaks. It is recommended to restart instead of using /bukkit:reload. To confirm, please type ", (TextColor)NamedTextColor.RED).append((Component)Component.text((String)"/bukkit:reload confirm", (TextColor)NamedTextColor.YELLOW)));
                return true;
            }
            Command.broadcastCommandMessage(sender, String.valueOf((Object)ChatColor.RED) + "Please note that this command is not supported, may cause issues when using some plugins, and will be removed soon.");
            Command.broadcastCommandMessage(sender, String.valueOf((Object)ChatColor.RED) + "If you encounter any issues please use the /stop command to restart your server.");
            try {
                Bukkit.reload();
            }
            catch (IllegalStateException ex) {
                if (!ex.getMessage().equals(RELOADING_DISABLED_MESSAGE)) break block11;
                Command.broadcastCommandMessage(sender, String.valueOf((Object)ChatColor.RED) + RELOADING_DISABLED_MESSAGE);
                return true;
            }
        }
        Command.broadcastCommandMessage(sender, String.valueOf((Object)ChatColor.GREEN) + "Reload complete.");
        return true;
    }

    @Override
    @NotNull
    public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String alias, @NotNull String[] args) throws IllegalArgumentException {
        return Lists.newArrayList((Object[])new String[]{"permissions", "commands"});
    }
}

