/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.event.player;

import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.inventory.ItemStack;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class PlayerInventorySlotChangeEvent
extends PlayerEvent {
    private static final HandlerList HANDLER_LIST = new HandlerList();
    private final int rawSlot;
    private final int slot;
    private final ItemStack oldItemStack;
    private final ItemStack newItemStack;
    private boolean triggerAdvancements = true;

    public PlayerInventorySlotChangeEvent(Player player, int rawSlot, ItemStack oldItemStack, ItemStack newItemStack) {
        super(player);
        this.rawSlot = rawSlot;
        this.slot = player.getOpenInventory().convertSlot(rawSlot);
        this.oldItemStack = oldItemStack;
        this.newItemStack = newItemStack;
    }

    public int getRawSlot() {
        return this.rawSlot;
    }

    public int getSlot() {
        return this.slot;
    }

    public ItemStack getOldItemStack() {
        return this.oldItemStack;
    }

    public ItemStack getNewItemStack() {
        return this.newItemStack;
    }

    public boolean shouldTriggerAdvancements() {
        return this.triggerAdvancements;
    }

    public void setShouldTriggerAdvancements(boolean triggerAdvancements) {
        this.triggerAdvancements = triggerAdvancements;
    }

    @Override
    public HandlerList getHandlers() {
        return HANDLER_LIST;
    }

    public static HandlerList getHandlerList() {
        return HANDLER_LIST;
    }
}

