/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.event.block;

import com.google.common.base.Preconditions;
import io.papermc.paper.block.LockableTileState;
import java.util.Objects;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.text.Component;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.event.block.BlockEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class BlockLockCheckEvent
extends BlockEvent {
    private static final HandlerList HANDLER_LIST = new HandlerList();
    private final Player player;
    private @Nullable Component lockedMessage;
    private @Nullable Sound lockedSound;
    private @Nullable ItemStack itemStack;
    private Event.Result result = Event.Result.DEFAULT;

    @ApiStatus.Internal
    public BlockLockCheckEvent(Block block, Player player, Component lockedMessage, Sound lockedSound) {
        super(block);
        this.player = player;
        this.lockedMessage = lockedMessage;
        this.lockedSound = lockedSound;
    }

    public LockableTileState getBlockState() {
        BlockState blockState = this.getBlock().getState();
        Preconditions.checkState((boolean)(blockState instanceof LockableTileState), (Object)"Block state of lock-checked block is no longer a lockable tile state!");
        return (LockableTileState)blockState;
    }

    public Player getPlayer() {
        return this.player;
    }

    public ItemStack getKeyItem() {
        return Objects.requireNonNullElseGet(this.itemStack, this.player.getInventory()::getItemInMainHand);
    }

    public void setKeyItem(ItemStack stack) {
        Preconditions.checkArgument((stack != null ? 1 : 0) != 0, (Object)"stack cannot be null");
        this.itemStack = stack;
    }

    public void resetKeyItem() {
        this.itemStack = null;
    }

    public boolean isUsingCustomKeyItemStack() {
        return this.itemStack != null;
    }

    public Event.Result getResult() {
        return this.result;
    }

    public void setResult(Event.Result result) {
        this.result = result;
    }

    public void denyWithMessageAndSound(@Nullable Component lockedMessage, @Nullable Sound lockedSound) {
        this.result = Event.Result.DENY;
        this.lockedMessage = lockedMessage;
        this.lockedSound = lockedSound;
    }

    public @Nullable Component getLockedMessage() {
        return this.lockedMessage;
    }

    public void setLockedMessage(@Nullable Component lockedMessage) {
        this.lockedMessage = lockedMessage;
    }

    public @Nullable Sound getLockedSound() {
        return this.lockedSound;
    }

    public void setLockedSound(@Nullable Sound lockedSound) {
        this.lockedSound = lockedSound;
    }

    @Override
    public HandlerList getHandlers() {
        return HANDLER_LIST;
    }

    public static HandlerList getHandlerList() {
        return HANDLER_LIST;
    }
}

