/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.event.entity;

import java.util.Collections;
import java.util.List;
import org.bukkit.entity.Entity;
import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;
import org.bukkit.event.entity.EntityEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class EntityTransformEvent
extends EntityEvent
implements Cancellable {
    private static final HandlerList HANDLER_LIST = new HandlerList();
    private final List<Entity> convertedList;
    private final Entity converted;
    private final TransformReason transformReason;
    private boolean cancelled;

    @ApiStatus.Internal
    public EntityTransformEvent(Entity original, List<Entity> convertedList, TransformReason transformReason) {
        super(original);
        this.convertedList = Collections.unmodifiableList(convertedList);
        this.converted = convertedList.getFirst();
        this.transformReason = transformReason;
    }

    public List<Entity> getTransformedEntities() {
        return this.convertedList;
    }

    public Entity getTransformedEntity() {
        return this.converted;
    }

    public TransformReason getTransformReason() {
        return this.transformReason;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }

    @Override
    public HandlerList getHandlers() {
        return HANDLER_LIST;
    }

    public static HandlerList getHandlerList() {
        return HANDLER_LIST;
    }

    public static enum TransformReason {
        CURED,
        FROZEN,
        INFECTION,
        DROWNED,
        SHEARED,
        LIGHTNING,
        SPLIT,
        PIGLIN_ZOMBIFIED,
        METAMORPHOSIS,
        UNKNOWN;

    }
}

