/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.event.executor;

import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Objects;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.plugin.EventExecutor;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.NullMarked;

@NullMarked
@ApiStatus.Internal
public final class EventExecutorFactory {
    private static final byte[] TEMPLATE_CLASS_BYTES;

    private EventExecutorFactory() {
    }

    public static EventExecutor create(Method method, Class<? extends Event> eventClass) {
        List<Class<? extends Event>> classData = List.of(method, eventClass);
        try {
            MethodHandles.Lookup newClass = MethodHandles.lookup().defineHiddenClassWithClassData(TEMPLATE_CLASS_BYTES, classData, true, new MethodHandles.Lookup.ClassOption[0]);
            return newClass.lookupClass().asSubclass(EventExecutor.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError((Object)e);
        }
    }

    static ClassData classData(MethodHandles.Lookup lookup) {
        try {
            Method method = MethodHandles.classDataAt(lookup, "_", Method.class, 0);
            MethodHandle mh = lookup.unreflect(method);
            if (Modifier.isStatic(method.getModifiers())) {
                mh = MethodHandles.dropArguments(mh, 0, new Class[]{Listener.class});
            }
            mh = mh.asType(MethodType.methodType(Void.TYPE, Listener.class, Event.class));
            Class eventClass = MethodHandles.classDataAt(lookup, "_", Class.class, 1);
            return new ClassData(method, mh, eventClass.asSubclass(Event.class));
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError((Object)e);
        }
    }

    static {
        try (InputStream is = EventExecutorFactory.class.getResourceAsStream("MethodHandleEventExecutorTemplate.class");){
            TEMPLATE_CLASS_BYTES = Objects.requireNonNull(is, "template class is missing").readAllBytes();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    record ClassData(Method method, MethodHandle methodHandle, Class<? extends Event> eventClass) {
    }
}

