/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.event.player;

import java.util.Collections;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public class PlayerShearEntityEvent
extends PlayerEvent
implements Cancellable {
    private static final HandlerList HANDLER_LIST = new HandlerList();
    private final Entity entity;
    private final ItemStack item;
    private final EquipmentSlot hand;
    private List<ItemStack> drops;
    private boolean cancelled;

    @ApiStatus.Internal
    public PlayerShearEntityEvent(@NotNull Player player, @NotNull Entity entity, @NotNull ItemStack item, @NotNull EquipmentSlot hand, @NotNull List<ItemStack> drops) {
        super(player);
        this.entity = entity;
        this.item = item;
        this.hand = hand;
        this.drops = drops;
    }

    @Deprecated(since="1.15.2", forRemoval=true)
    @ApiStatus.Internal
    public PlayerShearEntityEvent(@NotNull Player player, @NotNull Entity entity) {
        this(player, entity, new ItemStack(Material.SHEARS), EquipmentSlot.HAND, Collections.emptyList());
    }

    @NotNull
    public Entity getEntity() {
        return this.entity;
    }

    @NotNull
    public ItemStack getItem() {
        return this.item.clone();
    }

    @NotNull
    public EquipmentSlot getHand() {
        return this.hand;
    }

    @NotNull
    public @Unmodifiable List<ItemStack> getDrops() {
        return this.drops;
    }

    public void setDrops(@NotNull List<ItemStack> drops) {
        this.drops = List.copyOf(drops);
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }

    @Override
    @NotNull
    public HandlerList getHandlers() {
        return HANDLER_LIST;
    }

    @NotNull
    public static HandlerList getHandlerList() {
        return HANDLER_LIST;
    }
}

