/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.event.entity;

import java.util.List;
import org.bukkit.ExplosionResult;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;
import org.bukkit.event.entity.EntityEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class EntityExplodeEvent
extends EntityEvent
implements Cancellable {
    private static final HandlerList HANDLER_LIST = new HandlerList();
    private final Location location;
    private final List<Block> blocks;
    private float yield;
    private final ExplosionResult result;
    private boolean cancelled;

    @ApiStatus.Internal
    public EntityExplodeEvent(@NotNull Entity entity, @NotNull Location location, @NotNull List<Block> blocks, float yield, @NotNull ExplosionResult result) {
        super(entity);
        this.location = location;
        this.blocks = blocks;
        this.yield = yield;
        this.result = result;
    }

    @NotNull
    public ExplosionResult getExplosionResult() {
        return this.result;
    }

    @NotNull
    public List<Block> blockList() {
        return this.blocks;
    }

    @NotNull
    public Location getLocation() {
        return this.location.clone();
    }

    public float getYield() {
        return this.yield;
    }

    public void setYield(float yield) {
        this.yield = yield;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }

    @Override
    @NotNull
    public HandlerList getHandlers() {
        return HANDLER_LIST;
    }

    @NotNull
    public static HandlerList getHandlerList() {
        return HANDLER_LIST;
    }
}

