/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.registry.set;

import com.google.common.collect.Lists;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.TypedKey;
import io.papermc.paper.registry.set.RegistryKeySet;
import io.papermc.paper.registry.set.RegistryKeySetImpl;
import io.papermc.paper.registry.set.RegistryValueSet;
import io.papermc.paper.registry.set.RegistryValueSetImpl;
import org.bukkit.Keyed;
import org.jetbrains.annotations.Contract;

public sealed interface RegistrySet<T>
permits RegistryKeySet, RegistryValueSet {
    @Contract(value="_, _ -> new", pure=true)
    public static <T> RegistryValueSet<T> valueSet(RegistryKey<T> registryKey, Iterable<? extends T> values) {
        return RegistryValueSetImpl.create(registryKey, values);
    }

    @Contract(value="_, _ -> new", pure=true)
    public static <T extends Keyed> RegistryKeySet<T> keySetFromValues(RegistryKey<T> registryKey, Iterable<? extends T> values) {
        return RegistryKeySetImpl.create(registryKey, values);
    }

    @SafeVarargs
    public static <T extends Keyed> RegistryKeySet<T> keySet(RegistryKey<T> registryKey, TypedKey<T> ... keys) {
        return RegistrySet.keySet(registryKey, Lists.newArrayList((Object[])keys));
    }

    @Contract(value="_, _ -> new", pure=true)
    public static <T extends Keyed> RegistryKeySet<T> keySet(RegistryKey<T> registryKey, Iterable<TypedKey<T>> keys) {
        return new RegistryKeySetImpl<T>(registryKey, Lists.newArrayList(keys));
    }

    public RegistryKey<T> registryKey();

    public int size();

    default public boolean isEmpty() {
        return this.size() == 0;
    }
}

