/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.entity;

import com.google.common.base.Preconditions;
import io.papermc.paper.world.flag.FeatureDependant;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.Translatable;
import org.bukkit.attribute.Attributable;
import org.bukkit.entity.Allay;
import org.bukkit.entity.AreaEffectCloud;
import org.bukkit.entity.Armadillo;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Axolotl;
import org.bukkit.entity.Bat;
import org.bukkit.entity.Bee;
import org.bukkit.entity.Blaze;
import org.bukkit.entity.BlockDisplay;
import org.bukkit.entity.Bogged;
import org.bukkit.entity.Breeze;
import org.bukkit.entity.BreezeWindCharge;
import org.bukkit.entity.Camel;
import org.bukkit.entity.CamelHusk;
import org.bukkit.entity.Cat;
import org.bukkit.entity.CaveSpider;
import org.bukkit.entity.Chicken;
import org.bukkit.entity.Cod;
import org.bukkit.entity.CopperGolem;
import org.bukkit.entity.Cow;
import org.bukkit.entity.Creaking;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Dolphin;
import org.bukkit.entity.Donkey;
import org.bukkit.entity.DragonFireball;
import org.bukkit.entity.Drowned;
import org.bukkit.entity.Egg;
import org.bukkit.entity.ElderGuardian;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.EnderPearl;
import org.bukkit.entity.EnderSignal;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Endermite;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Evoker;
import org.bukkit.entity.EvokerFangs;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.Firework;
import org.bukkit.entity.FishHook;
import org.bukkit.entity.Fox;
import org.bukkit.entity.Frog;
import org.bukkit.entity.Ghast;
import org.bukkit.entity.Giant;
import org.bukkit.entity.GlowItemFrame;
import org.bukkit.entity.GlowSquid;
import org.bukkit.entity.Goat;
import org.bukkit.entity.Guardian;
import org.bukkit.entity.HappyGhast;
import org.bukkit.entity.Hoglin;
import org.bukkit.entity.Horse;
import org.bukkit.entity.Husk;
import org.bukkit.entity.Illusioner;
import org.bukkit.entity.Interaction;
import org.bukkit.entity.IronGolem;
import org.bukkit.entity.Item;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LeashHitch;
import org.bukkit.entity.LightningStrike;
import org.bukkit.entity.LingeringPotion;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Llama;
import org.bukkit.entity.LlamaSpit;
import org.bukkit.entity.MagmaCube;
import org.bukkit.entity.Mannequin;
import org.bukkit.entity.Marker;
import org.bukkit.entity.Mule;
import org.bukkit.entity.MushroomCow;
import org.bukkit.entity.Nautilus;
import org.bukkit.entity.Ocelot;
import org.bukkit.entity.OminousItemSpawner;
import org.bukkit.entity.Painting;
import org.bukkit.entity.Panda;
import org.bukkit.entity.Parched;
import org.bukkit.entity.Parrot;
import org.bukkit.entity.Phantom;
import org.bukkit.entity.Pig;
import org.bukkit.entity.PigZombie;
import org.bukkit.entity.Piglin;
import org.bukkit.entity.PiglinBrute;
import org.bukkit.entity.Pillager;
import org.bukkit.entity.Player;
import org.bukkit.entity.PolarBear;
import org.bukkit.entity.PufferFish;
import org.bukkit.entity.Rabbit;
import org.bukkit.entity.Ravager;
import org.bukkit.entity.Salmon;
import org.bukkit.entity.Sheep;
import org.bukkit.entity.Shulker;
import org.bukkit.entity.ShulkerBullet;
import org.bukkit.entity.Silverfish;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.SkeletonHorse;
import org.bukkit.entity.Slime;
import org.bukkit.entity.SmallFireball;
import org.bukkit.entity.Sniffer;
import org.bukkit.entity.Snowball;
import org.bukkit.entity.Snowman;
import org.bukkit.entity.SpectralArrow;
import org.bukkit.entity.Spider;
import org.bukkit.entity.SplashPotion;
import org.bukkit.entity.Squid;
import org.bukkit.entity.Stray;
import org.bukkit.entity.Strider;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.Tadpole;
import org.bukkit.entity.TextDisplay;
import org.bukkit.entity.ThrownExpBottle;
import org.bukkit.entity.TraderLlama;
import org.bukkit.entity.Trident;
import org.bukkit.entity.TropicalFish;
import org.bukkit.entity.Turtle;
import org.bukkit.entity.Vex;
import org.bukkit.entity.Villager;
import org.bukkit.entity.Vindicator;
import org.bukkit.entity.WanderingTrader;
import org.bukkit.entity.Warden;
import org.bukkit.entity.WindCharge;
import org.bukkit.entity.Witch;
import org.bukkit.entity.Wither;
import org.bukkit.entity.WitherSkeleton;
import org.bukkit.entity.WitherSkull;
import org.bukkit.entity.Wolf;
import org.bukkit.entity.Zoglin;
import org.bukkit.entity.Zombie;
import org.bukkit.entity.ZombieHorse;
import org.bukkit.entity.ZombieNautilus;
import org.bukkit.entity.ZombieVillager;
import org.bukkit.entity.boat.AcaciaBoat;
import org.bukkit.entity.boat.AcaciaChestBoat;
import org.bukkit.entity.boat.BambooChestRaft;
import org.bukkit.entity.boat.BambooRaft;
import org.bukkit.entity.boat.BirchBoat;
import org.bukkit.entity.boat.BirchChestBoat;
import org.bukkit.entity.boat.CherryBoat;
import org.bukkit.entity.boat.CherryChestBoat;
import org.bukkit.entity.boat.DarkOakBoat;
import org.bukkit.entity.boat.DarkOakChestBoat;
import org.bukkit.entity.boat.JungleBoat;
import org.bukkit.entity.boat.JungleChestBoat;
import org.bukkit.entity.boat.MangroveBoat;
import org.bukkit.entity.boat.MangroveChestBoat;
import org.bukkit.entity.boat.OakBoat;
import org.bukkit.entity.boat.OakChestBoat;
import org.bukkit.entity.boat.PaleOakBoat;
import org.bukkit.entity.boat.PaleOakChestBoat;
import org.bukkit.entity.boat.SpruceBoat;
import org.bukkit.entity.boat.SpruceChestBoat;
import org.bukkit.entity.minecart.CommandMinecart;
import org.bukkit.entity.minecart.ExplosiveMinecart;
import org.bukkit.entity.minecart.HopperMinecart;
import org.bukkit.entity.minecart.PoweredMinecart;
import org.bukkit.entity.minecart.RideableMinecart;
import org.bukkit.entity.minecart.SpawnerMinecart;
import org.bukkit.entity.minecart.StorageMinecart;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum EntityType implements Keyed,
Translatable,
net.kyori.adventure.translation.Translatable,
FeatureDependant
{
    ACACIA_BOAT("acacia_boat", AcaciaBoat.class, -1),
    ACACIA_CHEST_BOAT("acacia_chest_boat", AcaciaChestBoat.class, -1),
    ALLAY("allay", Allay.class, -1),
    AREA_EFFECT_CLOUD("area_effect_cloud", AreaEffectCloud.class, 3),
    ARMADILLO("armadillo", Armadillo.class, -1),
    ARMOR_STAND("armor_stand", ArmorStand.class, 30),
    ARROW("arrow", Arrow.class, 10),
    AXOLOTL("axolotl", Axolotl.class, -1),
    BAMBOO_CHEST_RAFT("bamboo_chest_raft", BambooChestRaft.class, -1),
    BAMBOO_RAFT("bamboo_raft", BambooRaft.class, -1),
    BAT("bat", Bat.class, 65),
    BEE("bee", Bee.class, -1),
    BIRCH_BOAT("birch_boat", BirchBoat.class, -1),
    BIRCH_CHEST_BOAT("birch_chest_boat", BirchChestBoat.class, -1),
    BLAZE("blaze", Blaze.class, 61),
    BLOCK_DISPLAY("block_display", BlockDisplay.class, -1),
    BOGGED("bogged", Bogged.class, -1),
    BREEZE("breeze", Breeze.class, -1),
    BREEZE_WIND_CHARGE("breeze_wind_charge", BreezeWindCharge.class, -1),
    CAMEL("camel", Camel.class, -1),
    CAMEL_HUSK("camel_husk", CamelHusk.class, -1),
    CAT("cat", Cat.class, -1),
    CAVE_SPIDER("cave_spider", CaveSpider.class, 59),
    CHERRY_BOAT("cherry_boat", CherryBoat.class, -1),
    CHERRY_CHEST_BOAT("cherry_chest_boat", CherryChestBoat.class, -1),
    CHEST_MINECART("chest_minecart", StorageMinecart.class, 43),
    CHICKEN("chicken", Chicken.class, 93),
    COD("cod", Cod.class, -1),
    COMMAND_BLOCK_MINECART("command_block_minecart", CommandMinecart.class, 40),
    COPPER_GOLEM("copper_golem", CopperGolem.class, -1),
    COW("cow", Cow.class, 92),
    CREAKING("creaking", Creaking.class, -1),
    CREEPER("creeper", Creeper.class, 50),
    DARK_OAK_BOAT("dark_oak_boat", DarkOakBoat.class, -1),
    DARK_OAK_CHEST_BOAT("dark_oak_chest_boat", DarkOakChestBoat.class, -1),
    DOLPHIN("dolphin", Dolphin.class, -1),
    DONKEY("donkey", Donkey.class, 31),
    DRAGON_FIREBALL("dragon_fireball", DragonFireball.class, 26),
    DROWNED("drowned", Drowned.class, -1),
    EGG("egg", Egg.class, 7),
    ELDER_GUARDIAN("elder_guardian", ElderGuardian.class, 4),
    END_CRYSTAL("end_crystal", EnderCrystal.class, 200),
    ENDER_DRAGON("ender_dragon", EnderDragon.class, 63),
    ENDER_PEARL("ender_pearl", EnderPearl.class, 14),
    ENDERMAN("enderman", Enderman.class, 58),
    ENDERMITE("endermite", Endermite.class, 67),
    EVOKER("evoker", Evoker.class, 34),
    EVOKER_FANGS("evoker_fangs", EvokerFangs.class, 33),
    EXPERIENCE_BOTTLE("experience_bottle", ThrownExpBottle.class, 17),
    EXPERIENCE_ORB("experience_orb", ExperienceOrb.class, 2),
    EYE_OF_ENDER("eye_of_ender", EnderSignal.class, 15),
    FALLING_BLOCK("falling_block", FallingBlock.class, 21),
    FIREBALL("fireball", Fireball.class, 12),
    FIREWORK_ROCKET("firework_rocket", Firework.class, 22),
    FISHING_BOBBER("fishing_bobber", FishHook.class, -1, false),
    FOX("fox", Fox.class, -1),
    FROG("frog", Frog.class, -1),
    FURNACE_MINECART("furnace_minecart", PoweredMinecart.class, 44),
    GHAST("ghast", Ghast.class, 56),
    GIANT("giant", Giant.class, 53),
    GLOW_ITEM_FRAME("glow_item_frame", GlowItemFrame.class, -1),
    GLOW_SQUID("glow_squid", GlowSquid.class, -1),
    GOAT("goat", Goat.class, -1),
    GUARDIAN("guardian", Guardian.class, 68),
    HAPPY_GHAST("happy_ghast", HappyGhast.class, -1),
    HOGLIN("hoglin", Hoglin.class, -1),
    HOPPER_MINECART("hopper_minecart", HopperMinecart.class, 46),
    HORSE("horse", Horse.class, 100),
    HUSK("husk", Husk.class, 23),
    ILLUSIONER("illusioner", Illusioner.class, 37),
    INTERACTION("interaction", Interaction.class, -1),
    IRON_GOLEM("iron_golem", IronGolem.class, 99),
    ITEM("item", Item.class, 1),
    ITEM_DISPLAY("item_display", ItemDisplay.class, -1),
    ITEM_FRAME("item_frame", ItemFrame.class, 18),
    JUNGLE_BOAT("jungle_boat", JungleBoat.class, -1),
    JUNGLE_CHEST_BOAT("jungle_chest_boat", JungleChestBoat.class, -1),
    LEASH_KNOT("leash_knot", LeashHitch.class, 8),
    LIGHTNING_BOLT("lightning_bolt", LightningStrike.class, -1),
    LINGERING_POTION("lingering_potion", LingeringPotion.class, -1),
    LLAMA("llama", Llama.class, 103),
    LLAMA_SPIT("llama_spit", LlamaSpit.class, 104),
    MAGMA_CUBE("magma_cube", MagmaCube.class, 62),
    MANGROVE_BOAT("mangrove_boat", MangroveBoat.class, -1),
    MANGROVE_CHEST_BOAT("mangrove_chest_boat", MangroveChestBoat.class, -1),
    MANNEQUIN("mannequin", Mannequin.class, -1),
    MARKER("marker", Marker.class, -1),
    MINECART("minecart", RideableMinecart.class, 42),
    MOOSHROOM("mooshroom", MushroomCow.class, 96),
    MULE("mule", Mule.class, 32),
    NAUTILUS("nautilus", Nautilus.class, -1),
    OAK_BOAT("oak_boat", OakBoat.class, -1),
    OAK_CHEST_BOAT("oak_chest_boat", OakChestBoat.class, -1),
    OCELOT("ocelot", Ocelot.class, 98),
    OMINOUS_ITEM_SPAWNER("ominous_item_spawner", OminousItemSpawner.class, -1),
    PAINTING("painting", Painting.class, 9),
    PALE_OAK_BOAT("pale_oak_boat", PaleOakBoat.class, -1),
    PALE_OAK_CHEST_BOAT("pale_oak_chest_boat", PaleOakChestBoat.class, -1),
    PANDA("panda", Panda.class, -1),
    PARCHED("parched", Parched.class, -1),
    PARROT("parrot", Parrot.class, 105),
    PHANTOM("phantom", Phantom.class, -1),
    PIG("pig", Pig.class, 90),
    PIGLIN("piglin", Piglin.class, -1),
    PIGLIN_BRUTE("piglin_brute", PiglinBrute.class, -1),
    PILLAGER("pillager", Pillager.class, -1),
    PLAYER("player", Player.class, -1, false),
    POLAR_BEAR("polar_bear", PolarBear.class, 102),
    PUFFERFISH("pufferfish", PufferFish.class, -1),
    RABBIT("rabbit", Rabbit.class, 101),
    RAVAGER("ravager", Ravager.class, -1),
    SALMON("salmon", Salmon.class, -1),
    SHEEP("sheep", Sheep.class, 91),
    SHULKER("shulker", Shulker.class, 69),
    SHULKER_BULLET("shulker_bullet", ShulkerBullet.class, 25),
    SILVERFISH("silverfish", Silverfish.class, 60),
    SKELETON("skeleton", Skeleton.class, 51),
    SKELETON_HORSE("skeleton_horse", SkeletonHorse.class, 28),
    SLIME("slime", Slime.class, 55),
    SMALL_FIREBALL("small_fireball", SmallFireball.class, 13),
    SNIFFER("sniffer", Sniffer.class, -1),
    SNOW_GOLEM("snow_golem", Snowman.class, 97),
    SNOWBALL("snowball", Snowball.class, 11),
    SPAWNER_MINECART("spawner_minecart", SpawnerMinecart.class, 47),
    SPECTRAL_ARROW("spectral_arrow", SpectralArrow.class, 24),
    SPIDER("spider", Spider.class, 52),
    SPLASH_POTION("splash_potion", SplashPotion.class, 16),
    SPRUCE_BOAT("spruce_boat", SpruceBoat.class, -1),
    SPRUCE_CHEST_BOAT("spruce_chest_boat", SpruceChestBoat.class, -1),
    SQUID("squid", Squid.class, 94),
    STRAY("stray", Stray.class, 6),
    STRIDER("strider", Strider.class, -1),
    TADPOLE("tadpole", Tadpole.class, -1),
    TEXT_DISPLAY("text_display", TextDisplay.class, -1),
    TNT("tnt", TNTPrimed.class, 20),
    TNT_MINECART("tnt_minecart", ExplosiveMinecart.class, 45),
    TRADER_LLAMA("trader_llama", TraderLlama.class, -1),
    TRIDENT("trident", Trident.class, -1),
    TROPICAL_FISH("tropical_fish", TropicalFish.class, -1),
    TURTLE("turtle", Turtle.class, -1),
    VEX("vex", Vex.class, 35),
    VILLAGER("villager", Villager.class, 120),
    VINDICATOR("vindicator", Vindicator.class, 36),
    WANDERING_TRADER("wandering_trader", WanderingTrader.class, -1),
    WARDEN("warden", Warden.class, -1),
    WIND_CHARGE("wind_charge", WindCharge.class, -1),
    WITCH("witch", Witch.class, 66),
    WITHER("wither", Wither.class, 64),
    WITHER_SKELETON("wither_skeleton", WitherSkeleton.class, 5),
    WITHER_SKULL("wither_skull", WitherSkull.class, 19),
    WOLF("wolf", Wolf.class, 95),
    ZOGLIN("zoglin", Zoglin.class, -1),
    ZOMBIE("zombie", Zombie.class, 54),
    ZOMBIE_HORSE("zombie_horse", ZombieHorse.class, 29),
    ZOMBIE_NAUTILUS("zombie_nautilus", ZombieNautilus.class, -1),
    ZOMBIE_VILLAGER("zombie_villager", ZombieVillager.class, 27),
    ZOMBIFIED_PIGLIN("zombified_piglin", PigZombie.class, 57),
    UNKNOWN(null, null, -1, false);

    private final String name;
    private final Class<? extends Entity> clazz;
    private final short typeId;
    private final boolean independent;
    private final boolean living;
    private final NamespacedKey key;
    private static final Map<String, EntityType> NAME_MAP;
    private static final Map<Short, EntityType> ID_MAP;

    private EntityType(String name, Class<? extends Entity> clazz, int typeId) {
        this(name, clazz, typeId, true);
    }

    private EntityType(String name, Class<? extends Entity> clazz, int typeId, boolean independent) {
        this.name = name;
        this.clazz = clazz;
        this.typeId = (short)typeId;
        this.independent = independent;
        this.living = clazz != null && LivingEntity.class.isAssignableFrom(clazz);
        this.key = name == null ? null : NamespacedKey.minecraft(name);
    }

    @Deprecated(since="1.6.2")
    @Nullable
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public NamespacedKey getKey() {
        Preconditions.checkArgument((this.key != null ? 1 : 0) != 0, (Object)"EntityType doesn't have key! Is it UNKNOWN?");
        return this.key;
    }

    @Nullable
    public Class<? extends Entity> getEntityClass() {
        return this.clazz;
    }

    @Deprecated(since="1.6.2", forRemoval=true)
    public short getTypeId() {
        return this.typeId;
    }

    @ApiStatus.Internal
    @Contract(value="null -> null")
    @Nullable
    public static EntityType fromName(@Nullable String name) {
        if (name == null) {
            return null;
        }
        return NAME_MAP.get(name.toLowerCase(Locale.ROOT));
    }

    @Deprecated(since="1.6.2", forRemoval=true)
    @Nullable
    public static EntityType fromId(int id) {
        if (id > Short.MAX_VALUE) {
            return null;
        }
        return ID_MAP.get((short)id);
    }

    public boolean isSpawnable() {
        return this.independent;
    }

    public boolean isAlive() {
        return this.living;
    }

    @Override
    @Deprecated(forRemoval=true)
    @NotNull
    public String getTranslationKey() {
        return Bukkit.getUnsafe().getTranslationKey(this);
    }

    @NotNull
    public String translationKey() {
        Preconditions.checkArgument((this != UNKNOWN ? 1 : 0) != 0, (Object)"UNKNOWN entities do not have translation keys");
        return Bukkit.getUnsafe().getTranslationKey(this);
    }

    public boolean hasDefaultAttributes() {
        return Bukkit.getUnsafe().hasDefaultEntityAttributes(this.key);
    }

    @NotNull
    public Attributable getDefaultAttributes() {
        return Bukkit.getUnsafe().getDefaultEntityAttributes(this.key);
    }

    static {
        NAME_MAP = new HashMap<String, EntityType>();
        ID_MAP = new HashMap<Short, EntityType>();
        for (EntityType type : EntityType.values()) {
            if (type.name != null) {
                NAME_MAP.put(type.name.toLowerCase(Locale.ROOT), type);
            }
            if (type.typeId <= 0) continue;
            ID_MAP.put(type.typeId, type);
        }
    }
}

