/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.event.entity;

import com.google.common.base.Preconditions;
import org.bukkit.entity.Entity;
import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;
import org.bukkit.event.entity.EntityEvent;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class EntityKnockbackEvent
extends EntityEvent
implements Cancellable {
    private static final HandlerList HANDLER_LIST = new HandlerList();
    private final Cause cause;
    protected Vector knockback;
    private boolean cancelled;

    @ApiStatus.Internal
    public EntityKnockbackEvent(Entity entity, Cause cause, Vector knockback) {
        super(entity);
        this.cause = cause;
        this.knockback = knockback;
    }

    public Cause getCause() {
        return this.cause;
    }

    public Vector getKnockback() {
        return this.knockback.clone();
    }

    public void setKnockback(Vector knockback) {
        Preconditions.checkArgument((knockback != null ? 1 : 0) != 0, (Object)"knockback");
        this.knockback = knockback.clone();
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }

    @Override
    public HandlerList getHandlers() {
        return HANDLER_LIST;
    }

    public static HandlerList getHandlerList() {
        return HANDLER_LIST;
    }

    public static enum Cause {
        DAMAGE,
        ENTITY_ATTACK,
        EXPLOSION,
        SHIELD_BLOCK,
        SWEEP_ATTACK,
        PUSH,
        UNKNOWN;

    }
}

