/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.event.player;

import io.papermc.paper.block.bed.BedEnterAction;
import io.papermc.paper.block.bed.BedRuleResult;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.event.player.PlayerEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class PlayerBedEnterEvent
extends PlayerEvent
implements Cancellable {
    private static final HandlerList HANDLER_LIST = new HandlerList();
    private final Block bed;
    private final BedEnterResult bedEnterResult;
    @NotNull
    private final BedEnterAction enterAction;
    private Event.Result useBed = Event.Result.DEFAULT;

    @ApiStatus.Internal
    public PlayerBedEnterEvent(@NotNull Player player, @NotNull Block bed, @NotNull BedEnterResult bedEnterResult, @NotNull BedEnterAction enterAction) {
        super(player);
        this.bed = bed;
        this.bedEnterResult = bedEnterResult;
        this.enterAction = enterAction;
    }

    @NotNull
    public Block getBed() {
        return this.bed;
    }

    @NotNull
    @ApiStatus.Obsolete(since="1.21.11")
    public BedEnterResult getBedEnterResult() {
        return this.bedEnterResult;
    }

    @ApiStatus.Experimental
    @NotNull
    public BedEnterAction enterAction() {
        return this.enterAction;
    }

    @NotNull
    public Event.Result useBed() {
        return this.useBed;
    }

    public void setUseBed(@NotNull Event.Result useBed) {
        this.useBed = useBed;
    }

    @Override
    public boolean isCancelled() {
        return this.useBed == Event.Result.DENY || this.useBed == Event.Result.DEFAULT && this.enterAction.canSleep() != BedRuleResult.ALLOWED;
    }

    @Override
    public void setCancelled(boolean cancel) {
        this.setUseBed(cancel ? Event.Result.DENY : (this.useBed() == Event.Result.DENY ? Event.Result.DEFAULT : this.useBed()));
    }

    @Override
    @NotNull
    public HandlerList getHandlers() {
        return HANDLER_LIST;
    }

    @NotNull
    public static HandlerList getHandlerList() {
        return HANDLER_LIST;
    }

    @ApiStatus.Obsolete(since="1.21.11")
    public static enum BedEnterResult {
        OK,
        NOT_POSSIBLE_HERE,
        NOT_POSSIBLE_NOW,
        TOO_FAR_AWAY,
        OBSTRUCTED,
        NOT_SAFE,
        OTHER_PROBLEM,
        EXPLOSION;

    }
}

