/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.event.entity;

import com.google.common.base.Preconditions;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;
import org.bukkit.event.entity.EntityEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class ArrowBodyCountChangeEvent
extends EntityEvent
implements Cancellable {
    private static final HandlerList HANDLER_LIST = new HandlerList();
    private final boolean reset;
    private final int oldAmount;
    private int newAmount;
    private boolean cancelled;

    @ApiStatus.Internal
    public ArrowBodyCountChangeEvent(@NotNull LivingEntity entity, int oldAmount, int newAmount, boolean reset) {
        super(entity);
        this.oldAmount = oldAmount;
        this.newAmount = newAmount;
        this.reset = reset;
    }

    public boolean isReset() {
        return this.reset;
    }

    public int getOldAmount() {
        return this.oldAmount;
    }

    public int getNewAmount() {
        return this.newAmount;
    }

    public void setNewAmount(int newAmount) {
        Preconditions.checkArgument((newAmount >= 0 ? 1 : 0) != 0, (Object)"New arrow amount must be >= 0");
        this.newAmount = newAmount;
    }

    @Override
    @NotNull
    public LivingEntity getEntity() {
        return (LivingEntity)this.entity;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }

    @Override
    @NotNull
    public HandlerList getHandlers() {
        return HANDLER_LIST;
    }

    @NotNull
    public static HandlerList getHandlerList() {
        return HANDLER_LIST;
    }
}

