/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.event.block;

import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;
import org.bukkit.event.block.BlockEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class BlockPhysicsEvent
extends BlockEvent
implements Cancellable {
    private static final HandlerList HANDLER_LIST = new HandlerList();
    private final BlockData changed;
    private final Block sourceBlock;
    private boolean cancelled;

    @Deprecated(forRemoval=true)
    @ApiStatus.Internal
    public BlockPhysicsEvent(Block block, BlockData changed, int sourceX, int sourceY, int sourceZ) {
        this(block, changed, block.getWorld().getBlockAt(sourceX, sourceY, sourceZ));
    }

    @ApiStatus.Internal
    public BlockPhysicsEvent(@NotNull Block block, @NotNull BlockData changed) {
        this(block, changed, block);
    }

    @ApiStatus.Internal
    public BlockPhysicsEvent(@NotNull Block block, @NotNull BlockData changed, @NotNull Block sourceBlock) {
        super(block);
        this.changed = changed;
        this.sourceBlock = sourceBlock;
    }

    @NotNull
    public Block getSourceBlock() {
        return this.sourceBlock;
    }

    @NotNull
    public Material getChangedType() {
        return this.changed.getMaterial();
    }

    @NotNull
    public BlockData getChangedBlockData() {
        return this.changed.clone();
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }

    @Override
    @NotNull
    public HandlerList getHandlers() {
        return HANDLER_LIST;
    }

    @NotNull
    public static HandlerList getHandlerList() {
        return HANDLER_LIST;
    }
}

