/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.event.player;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.jetbrains.annotations.Unmodifiable;
import org.jspecify.annotations.NullMarked;

@NullMarked
public abstract class AbstractRespawnEvent
extends PlayerEvent {
    protected Location respawnLocation;
    private final boolean isBedSpawn;
    private final boolean isAnchorSpawn;
    private final boolean missingRespawnBlock;
    private final PlayerRespawnEvent.RespawnReason respawnReason;
    private final Set<PlayerRespawnEvent.RespawnFlag> respawnFlags;

    protected AbstractRespawnEvent(Player respawnPlayer, Location respawnLocation, boolean isBedSpawn, boolean isAnchorSpawn, boolean missingRespawnBlock, PlayerRespawnEvent.RespawnReason respawnReason) {
        super(respawnPlayer);
        this.respawnLocation = respawnLocation;
        this.isBedSpawn = isBedSpawn;
        this.isAnchorSpawn = isAnchorSpawn;
        this.missingRespawnBlock = missingRespawnBlock;
        this.respawnReason = respawnReason;
        ImmutableSet.Builder builder = ImmutableSet.builder();
        if (respawnReason == PlayerRespawnEvent.RespawnReason.END_PORTAL) {
            builder.add((Object)PlayerRespawnEvent.RespawnFlag.END_PORTAL);
        }
        if (this.isBedSpawn) {
            builder.add((Object)PlayerRespawnEvent.RespawnFlag.BED_SPAWN);
        }
        if (this.isAnchorSpawn) {
            builder.add((Object)PlayerRespawnEvent.RespawnFlag.ANCHOR_SPAWN);
        }
        this.respawnFlags = builder.build();
    }

    public Location getRespawnLocation() {
        return this.respawnLocation.clone();
    }

    public boolean isBedSpawn() {
        return this.isBedSpawn;
    }

    public boolean isAnchorSpawn() {
        return this.isAnchorSpawn;
    }

    public boolean isMissingRespawnBlock() {
        return this.missingRespawnBlock;
    }

    public PlayerRespawnEvent.RespawnReason getRespawnReason() {
        return this.respawnReason;
    }

    @Deprecated
    public @Unmodifiable Set<PlayerRespawnEvent.RespawnFlag> getRespawnFlags() {
        return this.respawnFlags;
    }
}

