/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.registry.set;

import com.google.common.collect.Lists;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.set.RegistryValueSet;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
final class RegistryValueSetImpl<T>
extends Record
implements RegistryValueSet<T> {
    private final RegistryKey<T> registryKey;
    private final List<T> values;

    RegistryValueSetImpl(RegistryKey<T> registryKey, List<T> values) {
        values = List.copyOf(values);
        this.registryKey = registryKey;
        this.values = values;
    }

    static <T> RegistryValueSet<T> create(RegistryKey<T> registryKey, Iterable<? extends T> values) {
        return new RegistryValueSetImpl<T>(registryKey, Lists.newArrayList(values));
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{RegistryValueSetImpl.class, "registryKey;values", "registryKey", "values"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{RegistryValueSetImpl.class, "registryKey;values", "registryKey", "values"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{RegistryValueSetImpl.class, "registryKey;values", "registryKey", "values"}, this, o);
    }

    @Override
    public RegistryKey<T> registryKey() {
        return this.registryKey;
    }

    @Override
    public List<T> values() {
        return this.values;
    }
}

