/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.event.weather;

import org.bukkit.World;
import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;
import org.bukkit.event.weather.WeatherEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class ThunderChangeEvent
extends WeatherEvent
implements Cancellable {
    private static final HandlerList HANDLER_LIST = new HandlerList();
    private final boolean newThunderState;
    private final Cause cause;
    private boolean cancelled;

    @ApiStatus.Internal
    public ThunderChangeEvent(@NotNull World world, boolean newThunderState, @NotNull Cause cause) {
        super(world);
        this.newThunderState = newThunderState;
        this.cause = cause;
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.Internal
    public ThunderChangeEvent(@NotNull World world, boolean newThunderState) {
        this(world, newThunderState, Cause.UNKNOWN);
    }

    public boolean toThunderState() {
        return this.newThunderState;
    }

    @NotNull
    public Cause getCause() {
        return this.cause;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }

    @Override
    @NotNull
    public HandlerList getHandlers() {
        return HANDLER_LIST;
    }

    @NotNull
    public static HandlerList getHandlerList() {
        return HANDLER_LIST;
    }

    public static enum Cause {
        COMMAND,
        NATURAL,
        SLEEP,
        PLUGIN,
        UNKNOWN;

    }
}

