/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.event.block;

import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;
import org.bukkit.event.block.BlockEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockIgniteEvent
extends BlockEvent
implements Cancellable {
    private static final HandlerList HANDLER_LIST = new HandlerList();
    private final IgniteCause cause;
    private final Entity ignitingEntity;
    private final Block ignitingBlock;
    private boolean cancelled;

    @ApiStatus.Internal
    public BlockIgniteEvent(@NotNull Block block, @NotNull IgniteCause cause, @Nullable Entity ignitingEntity) {
        this(block, cause, ignitingEntity, null);
    }

    @ApiStatus.Internal
    public BlockIgniteEvent(@NotNull Block block, @NotNull IgniteCause cause, @NotNull Block ignitingBlock) {
        this(block, cause, null, ignitingBlock);
    }

    @ApiStatus.Internal
    public BlockIgniteEvent(@NotNull Block block, @NotNull IgniteCause cause, @Nullable Entity ignitingEntity, @Nullable Block ignitingBlock) {
        super(block);
        this.cause = cause;
        this.ignitingEntity = ignitingEntity;
        this.ignitingBlock = ignitingBlock;
    }

    @NotNull
    public IgniteCause getCause() {
        return this.cause;
    }

    @Nullable
    public Player getPlayer() {
        if (this.ignitingEntity instanceof Player) {
            return (Player)this.ignitingEntity;
        }
        return null;
    }

    @Nullable
    public Entity getIgnitingEntity() {
        return this.ignitingEntity;
    }

    @Nullable
    public Block getIgnitingBlock() {
        return this.ignitingBlock;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }

    @Override
    @NotNull
    public HandlerList getHandlers() {
        return HANDLER_LIST;
    }

    @NotNull
    public static HandlerList getHandlerList() {
        return HANDLER_LIST;
    }

    public static enum IgniteCause {
        LAVA,
        FLINT_AND_STEEL,
        SPREAD,
        LIGHTNING,
        FIREBALL,
        ENDER_CRYSTAL,
        EXPLOSION,
        ARROW;

    }
}

