/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.registry.data.dialog.input;

import io.papermc.paper.registry.data.dialog.DialogInstancesProvider;
import io.papermc.paper.registry.data.dialog.input.DialogInput;
import net.kyori.adventure.text.Component;
import org.checkerframework.checker.index.qual.Positive;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Range;
import org.jspecify.annotations.Nullable;

@ApiStatus.NonExtendable
public non-sealed interface TextDialogInput
extends DialogInput {
    @Contract(pure=true)
    public @Range(from=1L, to=1024L) int width();

    @Contract(pure=true)
    public Component label();

    @Contract(pure=true)
    public boolean labelVisible();

    @Contract(pure=true)
    public String initial();

    @Contract(pure=true)
    public @Positive int maxLength();

    @Contract(pure=true)
    public @Nullable MultilineOptions multiline();

    @ApiStatus.NonExtendable
    public static interface Builder {
        @Contract(value="_ -> this", mutates="this")
        public Builder width(@Range(from=1L, to=1024L) int var1);

        @Contract(value="_ -> this", mutates="this")
        public Builder labelVisible(boolean var1);

        @Contract(value="_ -> this", mutates="this")
        public Builder initial(String var1);

        @Contract(value="_ -> this", mutates="this")
        public Builder maxLength(@Positive int var1);

        @Contract(value="_ -> this", mutates="this")
        public Builder multiline(@Nullable MultilineOptions var1);

        @Contract(value="-> new", pure=true)
        public TextDialogInput build();
    }

    @ApiStatus.NonExtendable
    public static interface MultilineOptions {
        public static MultilineOptions create(@Positive @Nullable Integer maxLines, @Nullable @Range(from=1L, to=512L) Integer height) {
            return DialogInstancesProvider.instance().multilineOptions(maxLines, height);
        }

        @Contract(pure=true)
        public @Positive @Nullable Integer maxLines();

        @Contract(pure=true)
        public @Nullable @Range(from=1L, to=512L) Integer height();
    }
}

