/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.event.world;

import io.papermc.paper.math.Position;
import java.util.Collections;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;
import org.bukkit.event.world.WorldEvent;
import org.bukkit.generator.structure.Structure;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.UnmodifiableView;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class StructuresLocateEvent
extends WorldEvent
implements Cancellable {
    private static final HandlerList HANDLER_LIST = new HandlerList();
    private final Location origin;
    private @Nullable Result result;
    private List<Structure> structures;
    private int radius;
    private boolean findUnexplored;
    private boolean cancelled;

    @ApiStatus.Internal
    public StructuresLocateEvent(World world, Location origin, List<Structure> structures, int radius, boolean findUnexplored) {
        super(world);
        this.origin = origin;
        this.structures = structures;
        this.radius = radius;
        this.findUnexplored = findUnexplored;
    }

    public Location getOrigin() {
        return this.origin.clone();
    }

    public @Nullable Result getResult() {
        return this.result;
    }

    public void setResult(@Nullable Result result) {
        this.result = result;
    }

    public @UnmodifiableView List<Structure> getStructures() {
        return Collections.unmodifiableList(this.structures);
    }

    public void setStructures(List<Structure> structures) {
        this.structures = structures;
    }

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = radius;
    }

    public boolean shouldFindUnexplored() {
        return this.findUnexplored;
    }

    public void setFindUnexplored(boolean findUnexplored) {
        this.findUnexplored = findUnexplored;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }

    @Override
    public HandlerList getHandlers() {
        return HANDLER_LIST;
    }

    public static HandlerList getHandlerList() {
        return HANDLER_LIST;
    }

    public record Result(Position pos, Structure structure) {
        @Deprecated(forRemoval=true)
        public Location position() {
            return this.pos.toLocation(null);
        }
    }
}

