/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.event.player;

import com.google.common.base.Preconditions;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;
import org.bukkit.event.player.PlayerEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class PlayerJumpEvent
extends PlayerEvent
implements Cancellable {
    private static final HandlerList HANDLER_LIST = new HandlerList();
    private final Location to;
    private Location from;
    private boolean cancelled;

    @ApiStatus.Internal
    public PlayerJumpEvent(Player player, Location from, Location to) {
        super(player);
        this.from = from;
        this.to = to;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }

    public Location getFrom() {
        return this.from;
    }

    public void setFrom(Location from) {
        Preconditions.checkArgument((from != null ? 1 : 0) != 0, (Object)"Cannot use null from location!");
        Preconditions.checkArgument((from.getWorld() != null ? 1 : 0) != 0, (Object)"Cannot use from location with null world!");
        this.from = from.clone();
    }

    public Location getTo() {
        return this.to.clone();
    }

    @Override
    public HandlerList getHandlers() {
        return HANDLER_LIST;
    }

    public static HandlerList getHandlerList() {
        return HANDLER_LIST;
    }
}

