/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit;

import io.papermc.paper.math.Position;
import io.papermc.paper.raytracing.PositionedRayTraceConfigurationBuilder;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.audience.ForwardingAudience;
import org.bukkit.BlockChangeDelegate;
import org.bukkit.Chunk;
import org.bukkit.ChunkSnapshot;
import org.bukkit.Difficulty;
import org.bukkit.Effect;
import org.bukkit.FeatureFlag;
import org.bukkit.FluidCollisionMode;
import org.bukkit.GameEvent;
import org.bukkit.GameRule;
import org.bukkit.HeightMap;
import org.bukkit.Instrument;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Note;
import org.bukkit.Particle;
import org.bukkit.Raid;
import org.bukkit.RegionAccessor;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.StructureType;
import org.bukkit.TreeType;
import org.bukkit.WorldBorder;
import org.bukkit.WorldType;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.boss.DragonBattle;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Item;
import org.bukkit.entity.LightningStrike;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.SpawnCategory;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.generator.WorldInfo;
import org.bukkit.generator.structure.GeneratedStructure;
import org.bukkit.generator.structure.Structure;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.MaterialData;
import org.bukkit.metadata.Metadatable;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.PluginMessageRecipient;
import org.bukkit.util.BiomeSearchResult;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.StructureSearchResult;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface World
extends RegionAccessor,
WorldInfo,
PluginMessageRecipient,
Metadatable,
PersistentDataHolder,
Keyed,
ForwardingAudience {
    public boolean isVoidDamageEnabled();

    public void setVoidDamageEnabled(boolean var1);

    public float getVoidDamageAmount();

    public void setVoidDamageAmount(float var1);

    public double getVoidDamageMinBuildHeightOffset();

    public void setVoidDamageMinBuildHeightOffset(double var1);

    public int getEntityCount();

    public int getTileEntityCount();

    public int getTickableTileEntityCount();

    public int getChunkCount();

    public int getPlayerCount();

    public boolean hasStructureAt(@NotNull Position var1, @NotNull Structure var2);

    default public boolean isPositionLoaded(@NotNull Position position) {
        return this.isChunkLoaded(position.blockX() >> 4, position.blockZ() >> 4);
    }

    @NotNull
    public Block getBlockAt(int var1, int var2, int var3);

    @NotNull
    default public Block getBlockAt(@NotNull Location location) {
        return this.getBlockAt(location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    @Deprecated(since="1.18.1")
    @NotNull
    default public Block getBlockAtKey(long key) {
        int x = Block.getBlockKeyX(key);
        int y = Block.getBlockKeyY(key);
        int z = Block.getBlockKeyZ(key);
        return this.getBlockAt(x, y, z);
    }

    @Deprecated(since="1.18.1")
    @NotNull
    default public Location getLocationAtKey(long key) {
        int x = Block.getBlockKeyX(key);
        int y = Block.getBlockKeyY(key);
        int z = Block.getBlockKeyZ(key);
        return new Location(this, x, y, z);
    }

    @NotNull
    default public Block getHighestBlockAt(int x, int z) {
        return this.getBlockAt(x, this.getHighestBlockYAt(x, z), z);
    }

    @NotNull
    default public Block getHighestBlockAt(@NotNull Location location) {
        return this.getHighestBlockAt(location.getBlockX(), location.getBlockZ());
    }

    @NotNull
    default public Block getHighestBlockAt(int x, int z, @NotNull HeightMap heightMap) {
        return this.getBlockAt(x, this.getHighestBlockYAt(x, z, heightMap), z);
    }

    @NotNull
    default public Block getHighestBlockAt(@NotNull Location location, @NotNull HeightMap heightMap) {
        return this.getHighestBlockAt(location.getBlockX(), location.getBlockZ(), heightMap);
    }

    @NotNull
    public Chunk getChunkAt(int var1, int var2);

    @NotNull
    public Chunk getChunkAt(int var1, int var2, boolean var3);

    @NotNull
    default public Chunk getChunkAt(@NotNull Location location) {
        return this.getChunkAt(location.getBlockX() >> 4, location.getBlockZ() >> 4);
    }

    @NotNull
    public Chunk getChunkAt(@NotNull Block var1);

    @NotNull
    default public Chunk getChunkAt(long chunkKey) {
        return this.getChunkAt(chunkKey, true);
    }

    @NotNull
    default public Chunk getChunkAt(long chunkKey, boolean generate) {
        return this.getChunkAt((int)chunkKey, (int)(chunkKey >> 32), generate);
    }

    default public boolean isChunkGenerated(long chunkKey) {
        return this.isChunkGenerated((int)chunkKey, (int)(chunkKey >> 32));
    }

    public boolean isChunkLoaded(@NotNull Chunk var1);

    @NotNull
    public @NotNull Chunk @NotNull [] getLoadedChunks();

    public void loadChunk(@NotNull Chunk var1);

    public boolean isChunkLoaded(int var1, int var2);

    public boolean isChunkGenerated(int var1, int var2);

    @Deprecated(since="1.14")
    public boolean isChunkInUse(int var1, int var2);

    default public void loadChunk(int x, int z) {
        this.loadChunk(x, z, true);
    }

    public boolean loadChunk(int var1, int var2, boolean var3);

    default public boolean unloadChunk(@NotNull Chunk chunk) {
        return this.unloadChunk(chunk.getX(), chunk.getZ());
    }

    default public boolean unloadChunk(int x, int z) {
        return this.unloadChunk(x, z, true);
    }

    public boolean unloadChunk(int var1, int var2, boolean var3);

    public boolean unloadChunkRequest(int var1, int var2);

    @Deprecated(since="1.13", forRemoval=true)
    default public boolean regenerateChunk(int x, int z) {
        throw new UnsupportedOperationException("Not supported in this Minecraft version! This is not a bug.");
    }

    public boolean refreshChunk(int var1, int var2);

    @NotNull
    public Collection<Player> getPlayersSeeingChunk(@NotNull Chunk var1);

    @NotNull
    public Collection<Player> getPlayersSeeingChunk(int var1, int var2);

    public boolean isChunkForceLoaded(int var1, int var2);

    public void setChunkForceLoaded(int var1, int var2, boolean var3);

    @NotNull
    public Collection<Chunk> getForceLoadedChunks();

    public boolean addPluginChunkTicket(int var1, int var2, @NotNull Plugin var3);

    public boolean removePluginChunkTicket(int var1, int var2, @NotNull Plugin var3);

    public void removePluginChunkTickets(@NotNull Plugin var1);

    @NotNull
    public Collection<Plugin> getPluginChunkTickets(int var1, int var2);

    @NotNull
    public Map<Plugin, Collection<Chunk>> getPluginChunkTickets();

    @NotNull
    public Collection<Chunk> getIntersectingChunks(@NotNull BoundingBox var1);

    @NotNull
    default public Item dropItem(@NotNull Location location, @NotNull ItemStack item) {
        return this.dropItem(location, item, null);
    }

    @NotNull
    public Item dropItem(@NotNull Location var1, @NotNull ItemStack var2, @Nullable Consumer<? super Item> var3);

    @NotNull
    default public Item dropItemNaturally(@NotNull Location location, @NotNull ItemStack item) {
        return this.dropItemNaturally(location, item, null);
    }

    @NotNull
    public Item dropItemNaturally(@NotNull Location var1, @NotNull ItemStack var2, @Nullable Consumer<? super Item> var3);

    @NotNull
    default public Arrow spawnArrow(@NotNull Location location, @NotNull Vector direction, float speed, float spread) {
        return this.spawnArrow(location, direction, speed, spread, Arrow.class);
    }

    @NotNull
    public <T extends AbstractArrow> T spawnArrow(@NotNull Location var1, @NotNull Vector var2, float var3, float var4, @NotNull Class<T> var5);

    @Deprecated(since="1.21.6")
    public boolean generateTree(@NotNull Location var1, @NotNull TreeType var2);

    @Deprecated(since="1.17.1")
    public boolean generateTree(@NotNull Location var1, @NotNull TreeType var2, @NotNull BlockChangeDelegate var3);

    @NotNull
    public LightningStrike strikeLightning(@NotNull Location var1);

    @NotNull
    public LightningStrike strikeLightningEffect(@NotNull Location var1);

    @Nullable
    public Location findLightningRod(@NotNull Location var1);

    @Nullable
    public Location findLightningTarget(@NotNull Location var1);

    @Override
    @NotNull
    public List<Entity> getEntities();

    @Override
    @NotNull
    public List<LivingEntity> getLivingEntities();

    @Deprecated(since="1.1")
    @NotNull
    public <T extends Entity> Collection<T> getEntitiesByClass(Class<T> ... var1);

    @Override
    @NotNull
    public <T extends Entity> Collection<T> getEntitiesByClass(@NotNull Class<T> var1);

    @Override
    @NotNull
    public Collection<Entity> getEntitiesByClasses(Class<?> ... var1);

    @NotNull
    default public Collection<LivingEntity> getNearbyLivingEntities(@NotNull Location loc, double radius) {
        return this.getNearbyEntitiesByType(LivingEntity.class, loc, radius, radius, radius);
    }

    @NotNull
    default public Collection<LivingEntity> getNearbyLivingEntities(@NotNull Location loc, double xzRadius, double yRadius) {
        return this.getNearbyEntitiesByType(LivingEntity.class, loc, xzRadius, yRadius, xzRadius);
    }

    @NotNull
    default public Collection<LivingEntity> getNearbyLivingEntities(@NotNull Location loc, double xRadius, double yRadius, double zRadius) {
        return this.getNearbyEntitiesByType(LivingEntity.class, loc, xRadius, yRadius, zRadius);
    }

    @NotNull
    default public Collection<LivingEntity> getNearbyLivingEntities(@NotNull Location loc, double radius, @Nullable Predicate<? super LivingEntity> predicate) {
        return this.getNearbyEntitiesByType(LivingEntity.class, loc, radius, radius, radius, predicate);
    }

    @NotNull
    default public Collection<LivingEntity> getNearbyLivingEntities(@NotNull Location loc, double xzRadius, double yRadius, @Nullable Predicate<? super LivingEntity> predicate) {
        return this.getNearbyEntitiesByType(LivingEntity.class, loc, xzRadius, yRadius, xzRadius, predicate);
    }

    @NotNull
    default public Collection<LivingEntity> getNearbyLivingEntities(@NotNull Location loc, double xRadius, double yRadius, double zRadius, @Nullable Predicate<? super LivingEntity> predicate) {
        return this.getNearbyEntitiesByType(LivingEntity.class, loc, xRadius, yRadius, zRadius, predicate);
    }

    @NotNull
    default public Collection<Player> getNearbyPlayers(@NotNull Location loc, double radius) {
        return this.getNearbyEntitiesByType(Player.class, loc, radius, radius, radius);
    }

    @NotNull
    default public Collection<Player> getNearbyPlayers(@NotNull Location loc, double xzRadius, double yRadius) {
        return this.getNearbyEntitiesByType(Player.class, loc, xzRadius, yRadius, xzRadius);
    }

    @NotNull
    default public Collection<Player> getNearbyPlayers(@NotNull Location loc, double xRadius, double yRadius, double zRadius) {
        return this.getNearbyEntitiesByType(Player.class, loc, xRadius, yRadius, zRadius);
    }

    @NotNull
    default public Collection<Player> getNearbyPlayers(@NotNull Location loc, double radius, @Nullable Predicate<? super Player> predicate) {
        return this.getNearbyEntitiesByType(Player.class, loc, radius, radius, radius, predicate);
    }

    @NotNull
    default public Collection<Player> getNearbyPlayers(@NotNull Location loc, double xzRadius, double yRadius, @Nullable Predicate<? super Player> predicate) {
        return this.getNearbyEntitiesByType(Player.class, loc, xzRadius, yRadius, xzRadius, predicate);
    }

    @NotNull
    default public Collection<Player> getNearbyPlayers(@NotNull Location loc, double xRadius, double yRadius, double zRadius, @Nullable Predicate<? super Player> predicate) {
        return this.getNearbyEntitiesByType(Player.class, loc, xRadius, yRadius, zRadius, predicate);
    }

    @NotNull
    default public <T extends Entity> Collection<T> getNearbyEntitiesByType(@Nullable Class<? extends T> clazz, @NotNull Location loc, double radius) {
        return this.getNearbyEntitiesByType(clazz, loc, radius, radius, radius, null);
    }

    @NotNull
    default public <T extends Entity> Collection<T> getNearbyEntitiesByType(@Nullable Class<? extends T> clazz, @NotNull Location loc, double xzRadius, double yRadius) {
        return this.getNearbyEntitiesByType(clazz, loc, xzRadius, yRadius, xzRadius, null);
    }

    @NotNull
    default public <T extends Entity> Collection<T> getNearbyEntitiesByType(@Nullable Class<? extends T> clazz, @NotNull Location loc, double xRadius, double yRadius, double zRadius) {
        return this.getNearbyEntitiesByType(clazz, loc, xRadius, yRadius, zRadius, null);
    }

    @NotNull
    default public <T extends Entity> Collection<T> getNearbyEntitiesByType(@Nullable Class<? extends T> clazz, @NotNull Location loc, double radius, @Nullable Predicate<? super T> predicate) {
        return this.getNearbyEntitiesByType(clazz, loc, radius, radius, radius, predicate);
    }

    @NotNull
    default public <T extends Entity> Collection<T> getNearbyEntitiesByType(@Nullable Class<? extends T> clazz, @NotNull Location loc, double xzRadius, double yRadius, @Nullable Predicate<? super T> predicate) {
        return this.getNearbyEntitiesByType(clazz, loc, xzRadius, yRadius, xzRadius, predicate);
    }

    @NotNull
    default public <T extends Entity> Collection<T> getNearbyEntitiesByType(@Nullable Class<? extends T> clazz, @NotNull Location loc, double xRadius, double yRadius, double zRadius, @Nullable Predicate<? super T> predicate) {
        ArrayList<Entity> nearby = new ArrayList<Entity>();
        for (Entity entity : this.getNearbyEntities(loc, xRadius, yRadius, zRadius)) {
            if (clazz != null && !clazz.isInstance(entity) || predicate != null && !predicate.test(entity)) continue;
            nearby.add(entity);
        }
        return nearby;
    }

    @Deprecated(since="1.13.1")
    default public void getChunkAtAsync(int x, int z, @NotNull ChunkLoadCallback cb) {
        this.getChunkAtAsync(x, z, (Consumer<? super Chunk>)cb);
    }

    @Deprecated(since="1.13.1")
    default public void getChunkAtAsync(@NotNull Location loc, @NotNull ChunkLoadCallback cb) {
        this.getChunkAtAsync(loc.getBlockX() >> 4, loc.getBlockZ() >> 4, cb);
    }

    @Deprecated(since="1.13.1")
    default public void getChunkAtAsync(@NotNull Block block, @NotNull ChunkLoadCallback cb) {
        this.getChunkAtAsync(block.getX() >> 4, block.getZ() >> 4, cb);
    }

    default public void getChunkAtAsync(int x, int z, @NotNull Consumer<? super Chunk> cb) {
        this.getChunkAtAsync(x, z, true, cb);
    }

    default public void getChunkAtAsync(int x, int z, boolean gen, @NotNull Consumer<? super Chunk> cb) {
        this.getChunkAtAsync(x, z, gen, false, cb);
    }

    public void getChunkAtAsync(int var1, int var2, boolean var3, boolean var4, @NotNull Consumer<? super Chunk> var5);

    public void getChunksAtAsync(int var1, int var2, int var3, int var4, boolean var5, @NotNull Runnable var6);

    default public void getChunkAtAsync(@NotNull Location loc, @NotNull Consumer<? super Chunk> cb) {
        this.getChunkAtAsync((int)Math.floor(loc.getX()) >> 4, (int)Math.floor(loc.getZ()) >> 4, true, cb);
    }

    default public void getChunkAtAsync(@NotNull Location loc, boolean gen, @NotNull Consumer<? super Chunk> cb) {
        this.getChunkAtAsync((int)Math.floor(loc.getX()) >> 4, (int)Math.floor(loc.getZ()) >> 4, gen, cb);
    }

    default public void getChunkAtAsync(@NotNull Block block, @NotNull Consumer<? super Chunk> cb) {
        this.getChunkAtAsync(block.getX() >> 4, block.getZ() >> 4, true, cb);
    }

    default public void getChunkAtAsync(@NotNull Block block, boolean gen, @NotNull Consumer<? super Chunk> cb) {
        this.getChunkAtAsync(block.getX() >> 4, block.getZ() >> 4, gen, cb);
    }

    @NotNull
    default public CompletableFuture<Chunk> getChunkAtAsync(@NotNull Location loc) {
        return this.getChunkAtAsync((int)Math.floor(loc.getX()) >> 4, (int)Math.floor(loc.getZ()) >> 4, true);
    }

    @NotNull
    default public CompletableFuture<Chunk> getChunkAtAsync(@NotNull Location loc, boolean gen) {
        return this.getChunkAtAsync((int)Math.floor(loc.getX()) >> 4, (int)Math.floor(loc.getZ()) >> 4, gen);
    }

    @NotNull
    default public CompletableFuture<Chunk> getChunkAtAsync(@NotNull Block block) {
        return this.getChunkAtAsync(block.getX() >> 4, block.getZ() >> 4, true);
    }

    @NotNull
    default public CompletableFuture<Chunk> getChunkAtAsync(@NotNull Block block, boolean gen) {
        return this.getChunkAtAsync(block.getX() >> 4, block.getZ() >> 4, gen);
    }

    @NotNull
    default public CompletableFuture<Chunk> getChunkAtAsync(int x, int z) {
        return this.getChunkAtAsync(x, z, true);
    }

    @NotNull
    default public CompletableFuture<Chunk> getChunkAtAsync(int x, int z, boolean gen) {
        return this.getChunkAtAsync(x, z, gen, false);
    }

    @NotNull
    default public CompletableFuture<Chunk> getChunkAtAsyncUrgently(@NotNull Location loc) {
        return this.getChunkAtAsync((int)Math.floor(loc.getX()) >> 4, (int)Math.floor(loc.getZ()) >> 4, true, true);
    }

    @NotNull
    default public CompletableFuture<Chunk> getChunkAtAsyncUrgently(@NotNull Location loc, boolean gen) {
        return this.getChunkAtAsync((int)Math.floor(loc.getX()) >> 4, (int)Math.floor(loc.getZ()) >> 4, gen, true);
    }

    @NotNull
    default public CompletableFuture<Chunk> getChunkAtAsyncUrgently(@NotNull Block block) {
        return this.getChunkAtAsync(block.getX() >> 4, block.getZ() >> 4, true, true);
    }

    @NotNull
    default public CompletableFuture<Chunk> getChunkAtAsyncUrgently(@NotNull Block block, boolean gen) {
        return this.getChunkAtAsync(block.getX() >> 4, block.getZ() >> 4, gen, true);
    }

    @NotNull
    default public CompletableFuture<Chunk> getChunkAtAsyncUrgently(int x, int z) {
        return this.getChunkAtAsync(x, z, true, true);
    }

    @NotNull
    default public CompletableFuture<Chunk> getChunkAtAsync(int x, int z, boolean gen, boolean urgent) {
        CompletableFuture<Chunk> ret = new CompletableFuture<Chunk>();
        this.getChunkAtAsync(x, z, gen, urgent, ret::complete);
        return ret;
    }

    @NotNull
    public List<Player> getPlayers();

    @NotNull
    default public Iterable<? extends Audience> audiences() {
        return this.getPlayers();
    }

    @NotNull
    default public Collection<Entity> getNearbyEntities(@NotNull Location location, double x, double y, double z) {
        return this.getNearbyEntities(location, x, y, z, null);
    }

    @Nullable
    public Entity getEntity(@NotNull UUID var1);

    @NotNull
    public Collection<Entity> getNearbyEntities(@NotNull Location var1, double var2, double var4, double var6, @Nullable Predicate<? super Entity> var8);

    @NotNull
    default public Collection<Entity> getNearbyEntities(@NotNull BoundingBox boundingBox) {
        return this.getNearbyEntities(boundingBox, null);
    }

    @NotNull
    public Collection<Entity> getNearbyEntities(@NotNull BoundingBox var1, @Nullable Predicate<? super Entity> var2);

    @Nullable
    default public RayTraceResult rayTraceEntities(@NotNull Location start, @NotNull Vector direction, double maxDistance) {
        return this.rayTraceEntities(start, direction, maxDistance, null);
    }

    @Nullable
    default public RayTraceResult rayTraceEntities(@NotNull Location start, @NotNull Vector direction, double maxDistance, double raySize) {
        return this.rayTraceEntities(start, direction, maxDistance, raySize, null);
    }

    @Nullable
    default public RayTraceResult rayTraceEntities(@NotNull Location start, @NotNull Vector direction, double maxDistance, @Nullable Predicate<? super Entity> filter) {
        return this.rayTraceEntities(start, direction, maxDistance, 0.0, filter);
    }

    @Nullable
    default public RayTraceResult rayTraceEntities(@NotNull Location start, @NotNull Vector direction, double maxDistance, double raySize, @Nullable Predicate<? super Entity> filter) {
        return this.rayTraceEntities((Position)start, direction, maxDistance, raySize, filter);
    }

    @Nullable
    public RayTraceResult rayTraceEntities(@NotNull Position var1, @NotNull Vector var2, double var3, double var5, @Nullable Predicate<? super Entity> var7);

    @Nullable
    default public RayTraceResult rayTraceBlocks(@NotNull Location start, @NotNull Vector direction, double maxDistance) {
        return this.rayTraceBlocks(start, direction, maxDistance, FluidCollisionMode.NEVER);
    }

    @Nullable
    default public RayTraceResult rayTraceBlocks(@NotNull Location start, @NotNull Vector direction, double maxDistance, @NotNull FluidCollisionMode fluidCollisionMode) {
        return this.rayTraceBlocks(start, direction, maxDistance, fluidCollisionMode, false);
    }

    @Nullable
    default public RayTraceResult rayTraceBlocks(@NotNull Location start, @NotNull Vector direction, double maxDistance, @NotNull FluidCollisionMode fluidCollisionMode, boolean ignorePassableBlocks) {
        return this.rayTraceBlocks(start, direction, maxDistance, fluidCollisionMode, ignorePassableBlocks, null);
    }

    @Nullable
    public RayTraceResult rayTraceBlocks(@NotNull Position var1, @NotNull Vector var2, double var3, @NotNull FluidCollisionMode var5, boolean var6, @Nullable Predicate<? super Block> var7);

    @Nullable
    default public RayTraceResult rayTrace(@NotNull Location start, @NotNull Vector direction, double maxDistance, @NotNull FluidCollisionMode fluidCollisionMode, boolean ignorePassableBlocks, double raySize, @Nullable Predicate<? super Entity> filter) {
        return this.rayTrace(start, direction, maxDistance, fluidCollisionMode, ignorePassableBlocks, raySize, filter, null);
    }

    @Nullable
    public RayTraceResult rayTrace(@NotNull Position var1, @NotNull Vector var2, double var3, @NotNull FluidCollisionMode var5, boolean var6, double var7, @Nullable Predicate<? super Entity> var9, @Nullable Predicate<? super Block> var10);

    @Nullable
    public RayTraceResult rayTrace(@NotNull Consumer<PositionedRayTraceConfigurationBuilder> var1);

    @NotNull
    public Location getSpawnLocation();

    public boolean setSpawnLocation(@NotNull Location var1);

    public boolean setSpawnLocation(int var1, int var2, int var3, float var4);

    default public boolean setSpawnLocation(int x, int y, int z) {
        return this.setSpawnLocation(x, y, z, 0.0f);
    }

    public long getTime();

    public void setTime(long var1);

    public long getFullTime();

    public void setFullTime(long var1);

    public boolean isDayTime();

    public long getGameTime();

    public boolean hasStorm();

    public void setStorm(boolean var1);

    public int getWeatherDuration();

    public void setWeatherDuration(int var1);

    public boolean isThundering();

    public void setThundering(boolean var1);

    public int getThunderDuration();

    public void setThunderDuration(int var1);

    public boolean isClearWeather();

    public void setClearWeatherDuration(int var1);

    public int getClearWeatherDuration();

    default public boolean createExplosion(double x, double y, double z, float power) {
        return this.createExplosion(x, y, z, power, false, true);
    }

    default public boolean createExplosion(double x, double y, double z, float power, boolean setFire) {
        return this.createExplosion(x, y, z, power, setFire, true);
    }

    default public boolean createExplosion(double x, double y, double z, float power, boolean setFire, boolean breakBlocks) {
        return this.createExplosion(x, y, z, power, setFire, breakBlocks, null);
    }

    public boolean createExplosion(double var1, double var3, double var5, float var7, boolean var8, boolean var9, @Nullable Entity var10);

    default public boolean createExplosion(@NotNull Location loc, float power) {
        return this.createExplosion(loc, power, false);
    }

    default public boolean createExplosion(@NotNull Location loc, float power, boolean setFire) {
        return this.createExplosion(loc, power, setFire, true);
    }

    public boolean createExplosion(@Nullable Entity var1, @NotNull Location var2, float var3, boolean var4, boolean var5, boolean var6);

    default public boolean createExplosion(@Nullable Entity source, @NotNull Location loc, float power, boolean setFire, boolean breakBlocks) {
        return this.createExplosion(source, loc, power, setFire, breakBlocks, true);
    }

    default public boolean createExplosion(@Nullable Entity source, @NotNull Location loc, float power, boolean setFire) {
        return this.createExplosion(source, loc, power, setFire, true);
    }

    default public boolean createExplosion(@Nullable Entity source, @NotNull Location loc, float power) {
        return this.createExplosion(source, loc, power, true, true);
    }

    default public boolean createExplosion(@NotNull Entity source, float power, boolean setFire, boolean breakBlocks) {
        return this.createExplosion(source, source.getLocation(), power, setFire, breakBlocks);
    }

    default public boolean createExplosion(@NotNull Entity source, float power, boolean setFire) {
        return this.createExplosion(source, source.getLocation(), power, setFire, true);
    }

    default public boolean createExplosion(@NotNull Entity source, float power) {
        return this.createExplosion(source, source.getLocation(), power, true, true);
    }

    default public boolean createExplosion(@NotNull Location loc, float power, boolean setFire, boolean breakBlocks) {
        return this.createExplosion(loc, power, setFire, breakBlocks, null);
    }

    public boolean createExplosion(@NotNull Location var1, float var2, boolean var3, boolean var4, @Nullable Entity var5);

    @Deprecated(since="1.21.9")
    public boolean getPVP();

    @Deprecated(since="1.21.9")
    public void setPVP(boolean var1);

    @Nullable
    public ChunkGenerator getGenerator();

    @Nullable
    public BiomeProvider getBiomeProvider();

    default public void save() {
        this.save(false);
    }

    public void save(boolean var1);

    @NotNull
    public List<BlockPopulator> getPopulators();

    @NotNull
    public <T extends LivingEntity> T spawn(@NotNull Location var1, @NotNull Class<T> var2, @NotNull CreatureSpawnEvent.SpawnReason var3, boolean var4, @Nullable Consumer<? super T> var5) throws IllegalArgumentException;

    @Deprecated(since="1.20.2", forRemoval=true)
    @NotNull
    public FallingBlock spawnFallingBlock(@NotNull Location var1, @NotNull MaterialData var2) throws IllegalArgumentException;

    @NotNull
    @ApiStatus.Obsolete(since="1.20.2")
    public FallingBlock spawnFallingBlock(@NotNull Location var1, @NotNull BlockData var2) throws IllegalArgumentException;

    @Deprecated(since="1.7.5", forRemoval=true)
    @NotNull
    public FallingBlock spawnFallingBlock(@NotNull Location var1, @NotNull Material var2, byte var3) throws IllegalArgumentException;

    default public void playEffect(@NotNull Location location, @NotNull Effect effect, int data) {
        this.playEffect(location, effect, data, 64);
    }

    public void playEffect(@NotNull Location var1, @NotNull Effect var2, int var3, int var4);

    default public <T> void playEffect(@NotNull Location location, @NotNull Effect effect, @Nullable T data) {
        this.playEffect(location, effect, data, 64);
    }

    public <T> void playEffect(@NotNull Location var1, @NotNull Effect var2, @Nullable T var3, int var4);

    @NotNull
    public ChunkSnapshot getEmptyChunkSnapshot(int var1, int var2, boolean var3, boolean var4);

    public void setSpawnFlags(boolean var1, boolean var2);

    public boolean getAllowAnimals();

    public boolean getAllowMonsters();

    @Deprecated(since="1.15")
    @NotNull
    default public Biome getBiome(int x, int z) {
        return this.getBiome(x, 0, z);
    }

    @Deprecated(since="1.15")
    public void setBiome(int var1, int var2, @NotNull Biome var3);

    @Deprecated(since="1.15")
    default public double getTemperature(int x, int z) {
        return this.getTemperature(x, 0, z);
    }

    public double getTemperature(int var1, int var2, int var3);

    @Deprecated(since="1.15")
    default public double getHumidity(int x, int z) {
        return this.getHumidity(x, 0, z);
    }

    public double getHumidity(int var1, int var2, int var3);

    public int getLogicalHeight();

    public boolean isNatural();

    public boolean isBedWorks();

    public boolean hasSkyLight();

    public boolean hasCeiling();

    public boolean isPiglinSafe();

    public boolean isRespawnAnchorWorks();

    public boolean hasRaids();

    public boolean isUltraWarm();

    public int getSeaLevel();

    @Deprecated(since="1.20.5", forRemoval=true)
    default public boolean getKeepSpawnInMemory() {
        return false;
    }

    @Deprecated(since="1.20.5", forRemoval=true)
    default public void setKeepSpawnInMemory(boolean keepLoaded) {
    }

    public boolean isAutoSave();

    public void setAutoSave(boolean var1);

    public void setDifficulty(@NotNull Difficulty var1);

    @NotNull
    public Difficulty getDifficulty();

    public int getViewDistance();

    public int getSimulationDistance();

    @NotNull
    default public File getWorldFolder() {
        return this.getWorldPath().toFile();
    }

    @NotNull
    public Path getWorldPath();

    @Deprecated(since="1.16.1")
    @Nullable
    public WorldType getWorldType();

    public boolean canGenerateStructures();

    public boolean hasBonusChest();

    public boolean isHardcore();

    public void setHardcore(boolean var1);

    @Deprecated(since="1.18.1")
    default public long getTicksPerAnimalSpawns() {
        return this.getTicksPerSpawns(SpawnCategory.ANIMAL);
    }

    @Deprecated(since="1.18.1")
    default public void setTicksPerAnimalSpawns(int ticksPerAnimalSpawns) {
        this.setTicksPerSpawns(SpawnCategory.ANIMAL, ticksPerAnimalSpawns);
    }

    @Deprecated(since="1.18.1")
    default public long getTicksPerMonsterSpawns() {
        return this.getTicksPerSpawns(SpawnCategory.MONSTER);
    }

    @Deprecated(since="1.18.1")
    default public void setTicksPerMonsterSpawns(int ticksPerMonsterSpawns) {
        this.setTicksPerSpawns(SpawnCategory.MONSTER, ticksPerMonsterSpawns);
    }

    @Deprecated(since="1.18.1")
    default public long getTicksPerWaterSpawns() {
        return this.getTicksPerSpawns(SpawnCategory.WATER_ANIMAL);
    }

    @Deprecated(since="1.18.1")
    default public void setTicksPerWaterSpawns(int ticksPerWaterSpawns) {
        this.setTicksPerSpawns(SpawnCategory.WATER_ANIMAL, ticksPerWaterSpawns);
    }

    @Deprecated(since="1.18.1")
    default public long getTicksPerWaterAmbientSpawns() {
        return this.getTicksPerSpawns(SpawnCategory.WATER_AMBIENT);
    }

    @Deprecated(since="1.18.1")
    default public void setTicksPerWaterAmbientSpawns(int ticksPerWaterAmbientSpawns) {
        this.setTicksPerSpawns(SpawnCategory.WATER_AMBIENT, ticksPerWaterAmbientSpawns);
    }

    @Deprecated(since="1.18.1")
    default public long getTicksPerWaterUndergroundCreatureSpawns() {
        return this.getTicksPerSpawns(SpawnCategory.WATER_UNDERGROUND_CREATURE);
    }

    @Deprecated(since="1.18.1")
    default public void setTicksPerWaterUndergroundCreatureSpawns(int ticksPerWaterUndergroundCreatureSpawns) {
        this.setTicksPerSpawns(SpawnCategory.WATER_UNDERGROUND_CREATURE, ticksPerWaterUndergroundCreatureSpawns);
    }

    @Deprecated(since="1.18.1")
    default public long getTicksPerAmbientSpawns() {
        return this.getTicksPerSpawns(SpawnCategory.AMBIENT);
    }

    @Deprecated(since="1.18.1")
    default public void setTicksPerAmbientSpawns(int ticksPerAmbientSpawns) {
        this.setTicksPerSpawns(SpawnCategory.AMBIENT, ticksPerAmbientSpawns);
    }

    public long getTicksPerSpawns(@NotNull SpawnCategory var1);

    public void setTicksPerSpawns(@NotNull SpawnCategory var1, int var2);

    @Deprecated(since="1.18.1")
    default public int getMonsterSpawnLimit() {
        return this.getSpawnLimit(SpawnCategory.MONSTER);
    }

    @Deprecated(since="1.18.1")
    default public void setMonsterSpawnLimit(int limit) {
        this.setSpawnLimit(SpawnCategory.MONSTER, limit);
    }

    @Deprecated(since="1.18.1")
    default public int getAnimalSpawnLimit() {
        return this.getSpawnLimit(SpawnCategory.ANIMAL);
    }

    @Deprecated(since="1.18.1")
    default public void setAnimalSpawnLimit(int limit) {
        this.setSpawnLimit(SpawnCategory.ANIMAL, limit);
    }

    @Deprecated(since="1.18.1")
    default public int getWaterAnimalSpawnLimit() {
        return this.getSpawnLimit(SpawnCategory.WATER_ANIMAL);
    }

    @Deprecated(since="1.18.1")
    default public void setWaterAnimalSpawnLimit(int limit) {
        this.setSpawnLimit(SpawnCategory.WATER_ANIMAL, limit);
    }

    @Deprecated(since="1.18.1")
    default public int getWaterUndergroundCreatureSpawnLimit() {
        return this.getSpawnLimit(SpawnCategory.WATER_UNDERGROUND_CREATURE);
    }

    @Deprecated(since="1.18.1")
    default public void setWaterUndergroundCreatureSpawnLimit(int limit) {
        this.setSpawnLimit(SpawnCategory.WATER_UNDERGROUND_CREATURE, limit);
    }

    @Deprecated(since="1.18.1")
    default public int getWaterAmbientSpawnLimit() {
        return this.getSpawnLimit(SpawnCategory.WATER_AMBIENT);
    }

    @Deprecated(since="1.18.1")
    default public void setWaterAmbientSpawnLimit(int limit) {
        this.setSpawnLimit(SpawnCategory.WATER_AMBIENT, limit);
    }

    @Deprecated(since="1.18.1")
    default public int getAmbientSpawnLimit() {
        return this.getSpawnLimit(SpawnCategory.AMBIENT);
    }

    @Deprecated(since="1.18.1")
    default public void setAmbientSpawnLimit(int limit) {
        this.setSpawnLimit(SpawnCategory.AMBIENT, limit);
    }

    public int getSpawnLimit(@NotNull SpawnCategory var1);

    public void setSpawnLimit(@NotNull SpawnCategory var1, int var2);

    default public void playNote(@NotNull Location loc, @NotNull Instrument instrument, @NotNull Note note) {
        this.playSound(loc, instrument.getSound(), SoundCategory.RECORDS, 3.0f, note.getPitch());
    }

    default public void playSound(@NotNull Location location, @NotNull Sound sound, float volume, float pitch) {
        this.playSound(location, sound, SoundCategory.MASTER, volume, pitch);
    }

    default public void playSound(@NotNull Location location, @NotNull String sound, float volume, float pitch) {
        this.playSound(location, sound, SoundCategory.MASTER, volume, pitch);
    }

    public void playSound(@NotNull Location var1, @NotNull Sound var2, @NotNull SoundCategory var3, float var4, float var5);

    public void playSound(@NotNull Location var1, @NotNull String var2, @NotNull SoundCategory var3, float var4, float var5);

    public void playSound(@NotNull Location var1, @NotNull Sound var2, @NotNull SoundCategory var3, float var4, float var5, long var6);

    public void playSound(@NotNull Location var1, @NotNull String var2, @NotNull SoundCategory var3, float var4, float var5, long var6);

    default public void playSound(@NotNull Entity entity, @NotNull Sound sound, float volume, float pitch) {
        this.playSound(entity, sound, SoundCategory.MASTER, volume, pitch);
    }

    default public void playSound(@NotNull Entity entity, @NotNull String sound, float volume, float pitch) {
        this.playSound(entity, sound, SoundCategory.MASTER, volume, pitch);
    }

    public void playSound(@NotNull Entity var1, @NotNull Sound var2, @NotNull SoundCategory var3, float var4, float var5);

    public void playSound(@NotNull Entity var1, @NotNull String var2, @NotNull SoundCategory var3, float var4, float var5);

    public void playSound(@NotNull Entity var1, @NotNull Sound var2, @NotNull SoundCategory var3, float var4, float var5, long var6);

    public void playSound(@NotNull Entity var1, @NotNull String var2, @NotNull SoundCategory var3, float var4, float var5, long var6);

    @NotNull
    public @NotNull String @NotNull [] getGameRules();

    @Deprecated(since="1.13")
    @Contract(value="null -> null; !null -> !null")
    @Nullable
    public String getGameRuleValue(@Nullable String var1);

    @Deprecated(since="1.13")
    public boolean setGameRuleValue(@NotNull String var1, @NotNull String var2);

    public boolean isGameRule(@NotNull String var1);

    @Nullable
    public <T> T getGameRuleValue(@NotNull GameRule<T> var1);

    @Nullable
    public <T> T getGameRuleDefault(@NotNull GameRule<T> var1);

    public <T> boolean setGameRule(@NotNull GameRule<T> var1, @NotNull T var2);

    @NotNull
    public WorldBorder getWorldBorder();

    default public void spawnParticle(@NotNull Particle particle, @NotNull Location location, int count) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count);
    }

    default public void spawnParticle(@NotNull Particle particle, double x, double y, double z, int count) {
        this.spawnParticle(particle, x, y, z, count, null);
    }

    default public <T> void spawnParticle(@NotNull Particle particle, @NotNull Location location, int count, @Nullable T data) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, data);
    }

    default public <T> void spawnParticle(@NotNull Particle particle, double x, double y, double z, int count, @Nullable T data) {
        this.spawnParticle(particle, x, y, z, count, 0.0, 0.0, 0.0, data);
    }

    default public void spawnParticle(@NotNull Particle particle, @NotNull Location location, int count, double offsetX, double offsetY, double offsetZ) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ);
    }

    default public void spawnParticle(@NotNull Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ) {
        this.spawnParticle(particle, x, y, z, count, offsetX, offsetY, offsetZ, null);
    }

    default public <T> void spawnParticle(@NotNull Particle particle, @NotNull Location location, int count, double offsetX, double offsetY, double offsetZ, @Nullable T data) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ, data);
    }

    default public <T> void spawnParticle(@NotNull Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, @Nullable T data) {
        this.spawnParticle(particle, x, y, z, count, offsetX, offsetY, offsetZ, 1.0, data);
    }

    default public void spawnParticle(@NotNull Particle particle, @NotNull Location location, int count, double offsetX, double offsetY, double offsetZ, double extra) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ, extra);
    }

    default public void spawnParticle(@NotNull Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, double extra) {
        this.spawnParticle(particle, x, y, z, count, offsetX, offsetY, offsetZ, extra, null);
    }

    default public <T> void spawnParticle(@NotNull Particle particle, @NotNull Location location, int count, double offsetX, double offsetY, double offsetZ, double extra, @Nullable T data) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ, extra, data);
    }

    default public <T> void spawnParticle(@NotNull Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, double extra, @Nullable T data) {
        this.spawnParticle(particle, null, null, x, y, z, count, offsetX, offsetY, offsetZ, extra, data, true);
    }

    default public <T> void spawnParticle(@NotNull Particle particle, @Nullable List<Player> receivers, @NotNull Player source, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, double extra, @Nullable T data) {
        this.spawnParticle(particle, receivers, source, x, y, z, count, offsetX, offsetY, offsetZ, extra, data, true);
    }

    public <T> void spawnParticle(@NotNull Particle var1, @Nullable List<Player> var2, @Nullable Player var3, double var4, double var6, double var8, int var10, double var11, double var13, double var15, double var17, @Nullable T var19, boolean var20);

    default public <T> void spawnParticle(@NotNull Particle particle, @NotNull Location location, int count, double offsetX, double offsetY, double offsetZ, double extra, @Nullable T data, boolean force) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ, extra, data, force);
    }

    default public <T> void spawnParticle(@NotNull Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, double extra, @Nullable T data, boolean force) {
        this.spawnParticle(particle, null, null, x, y, z, count, offsetX, offsetY, offsetZ, extra, data, force);
    }

    @Deprecated(since="1.19")
    @Nullable
    public Location locateNearestStructure(@NotNull Location var1, @NotNull StructureType var2, int var3, boolean var4);

    @Nullable
    public StructureSearchResult locateNearestStructure(@NotNull Location var1, @NotNull org.bukkit.generator.structure.StructureType var2, int var3, boolean var4);

    @Nullable
    public StructureSearchResult locateNearestStructure(@NotNull Location var1, @NotNull Structure var2, int var3, boolean var4);

    @Deprecated
    @Nullable
    default public Location locateNearestBiome(@NotNull Location origin, @NotNull Biome biome, int radius) {
        return Optional.ofNullable(this.locateNearestBiome(origin, radius, 8, 8, biome)).map(BiomeSearchResult::getLocation).orElse(null);
    }

    @Deprecated
    @Nullable
    default public Location locateNearestBiome(@NotNull Location origin, @NotNull Biome biome, int radius, int step) {
        return Optional.ofNullable(this.locateNearestBiome(origin, radius, step, step, biome)).map(BiomeSearchResult::getLocation).orElse(null);
    }

    public double getCoordinateScale();

    public boolean isFixedTime();

    @NotNull
    public Collection<Material> getInfiniburn();

    public void sendGameEvent(@Nullable Entity var1, @NotNull GameEvent var2, @NotNull Vector var3);

    @Deprecated
    @NotNull
    public Spigot spigot();

    @Nullable
    default public BiomeSearchResult locateNearestBiome(@NotNull Location origin, int radius, Biome ... biomes) {
        return this.locateNearestBiome(origin, radius, 32, 64, biomes);
    }

    @Nullable
    public BiomeSearchResult locateNearestBiome(@NotNull Location var1, int var2, int var3, int var4, Biome ... var5);

    @Nullable
    public Raid locateNearestRaid(@NotNull Location var1, int var2);

    @Nullable
    public Raid getRaid(int var1);

    @NotNull
    public List<Raid> getRaids();

    @Nullable
    public DragonBattle getEnderDragonBattle();

    @Override
    @NotNull
    public Set<FeatureFlag> getFeatureFlags();

    public void setViewDistance(int var1);

    public void setSimulationDistance(int var1);

    @Deprecated
    default public int getNoTickViewDistance() {
        return this.getViewDistance();
    }

    @Deprecated
    default public void setNoTickViewDistance(int viewDistance) {
        this.setViewDistance(viewDistance);
    }

    public int getSendViewDistance();

    public void setSendViewDistance(int var1);

    @NotNull
    public Collection<GeneratedStructure> getStructures(int var1, int var2);

    @NotNull
    public Collection<GeneratedStructure> getStructures(int var1, int var2, @NotNull Structure var3);

    @Deprecated(since="1.13.1")
    public static interface ChunkLoadCallback
    extends Consumer<Chunk> {
        public void onLoad(@NotNull Chunk var1);

        @Override
        default public void accept(@NotNull Chunk chunk) {
            this.onLoad(chunk);
        }
    }

    public static enum Environment {
        NORMAL(0),
        NETHER(-1),
        THE_END(1),
        CUSTOM(-999);

        private final int id;
        private static final Map<Integer, Environment> lookup;

        private Environment(int id) {
            this.id = id;
        }

        @ApiStatus.Internal
        public int getId() {
            return this.id;
        }

        @ApiStatus.Internal
        @Nullable
        public static Environment getEnvironment(int id) {
            return lookup.get(id);
        }

        static {
            lookup = new HashMap<Integer, Environment>();
            for (Environment env : Environment.values()) {
                lookup.put(env.getId(), env);
            }
        }
    }

    @Deprecated(forRemoval=true)
    public static class Spigot {
        @Deprecated(since="1.20.4")
        @NotNull
        public LightningStrike strikeLightning(@NotNull Location loc, boolean isSilent) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Deprecated(since="1.20.4")
        @NotNull
        public LightningStrike strikeLightningEffect(@NotNull Location loc, boolean isSilent) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

