/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.event.server;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class GS4QueryEvent
extends Event {
    private static final HandlerList HANDLER_LIST = new HandlerList();
    private final QueryType queryType;
    private final InetAddress querierAddress;
    private QueryResponse response;

    @ApiStatus.Internal
    public GS4QueryEvent(QueryType queryType, InetAddress querierAddress, QueryResponse response) {
        super(true);
        this.queryType = queryType;
        this.querierAddress = querierAddress;
        this.response = response;
    }

    public QueryType getQueryType() {
        return this.queryType;
    }

    public InetAddress getQuerierAddress() {
        return this.querierAddress;
    }

    public QueryResponse getResponse() {
        return this.response;
    }

    public void setResponse(QueryResponse response) {
        this.response = (QueryResponse)Preconditions.checkNotNull((Object)response, (Object)"response");
    }

    @Override
    public HandlerList getHandlers() {
        return HANDLER_LIST;
    }

    public static HandlerList getHandlerList() {
        return HANDLER_LIST;
    }

    public static enum QueryType {
        BASIC,
        FULL;

    }

    public static final class QueryResponse {
        private final String motd;
        private final String gameVersion;
        private final String map;
        private final int currentPlayers;
        private final int maxPlayers;
        private final String hostname;
        private final int port;
        private final Collection<String> players;
        private final String serverVersion;
        private final Collection<PluginInformation> plugins;

        private QueryResponse(String motd, String gameVersion, String map, int currentPlayers, int maxPlayers, String hostname, int port, Collection<String> players, String serverVersion, Collection<PluginInformation> plugins) {
            this.motd = motd;
            this.gameVersion = gameVersion;
            this.map = map;
            this.currentPlayers = currentPlayers;
            this.maxPlayers = maxPlayers;
            this.hostname = hostname;
            this.port = port;
            this.players = players;
            this.serverVersion = serverVersion;
            this.plugins = plugins;
        }

        public String getMotd() {
            return this.motd;
        }

        public String getGameVersion() {
            return this.gameVersion;
        }

        public String getMap() {
            return this.map;
        }

        public int getCurrentPlayers() {
            return this.currentPlayers;
        }

        public int getMaxPlayers() {
            return this.maxPlayers;
        }

        public String getHostname() {
            return this.hostname;
        }

        public int getPort() {
            return this.port;
        }

        public Collection<String> getPlayers() {
            return this.players;
        }

        public String getServerVersion() {
            return this.serverVersion;
        }

        public Collection<PluginInformation> getPlugins() {
            return this.plugins;
        }

        public Builder toBuilder() {
            return QueryResponse.builder().motd(this.getMotd()).gameVersion(this.getGameVersion()).map(this.getMap()).currentPlayers(this.getCurrentPlayers()).maxPlayers(this.getMaxPlayers()).hostname(this.getHostname()).port(this.getPort()).players(this.getPlayers()).serverVersion(this.getServerVersion()).plugins(this.getPlugins());
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private @MonotonicNonNull String motd;
            private @MonotonicNonNull String gameVersion;
            private @MonotonicNonNull String map;
            private @MonotonicNonNull String hostname;
            private @MonotonicNonNull String serverVersion;
            private int currentPlayers;
            private int maxPlayers;
            private int port;
            private final List<String> players = new ArrayList<String>();
            private final List<PluginInformation> plugins = new ArrayList<PluginInformation>();

            private Builder() {
            }

            public Builder motd(String motd) {
                this.motd = (String)Preconditions.checkNotNull((Object)motd, (Object)"motd");
                return this;
            }

            public Builder gameVersion(String gameVersion) {
                this.gameVersion = (String)Preconditions.checkNotNull((Object)gameVersion, (Object)"gameVersion");
                return this;
            }

            public Builder map(String map) {
                this.map = (String)Preconditions.checkNotNull((Object)map, (Object)"map");
                return this;
            }

            public Builder currentPlayers(int currentPlayers) {
                Preconditions.checkArgument((currentPlayers >= 0 ? 1 : 0) != 0, (Object)"currentPlayers cannot be negative");
                this.currentPlayers = currentPlayers;
                return this;
            }

            public Builder maxPlayers(int maxPlayers) {
                Preconditions.checkArgument((maxPlayers >= 0 ? 1 : 0) != 0, (Object)"maxPlayers cannot be negative");
                this.maxPlayers = maxPlayers;
                return this;
            }

            public Builder hostname(String hostname) {
                this.hostname = (String)Preconditions.checkNotNull((Object)hostname, (Object)"hostname");
                return this;
            }

            public Builder port(int port) {
                Preconditions.checkArgument((port >= 1 && port <= 65535 ? 1 : 0) != 0, (Object)"port must be between 1-65535");
                this.port = port;
                return this;
            }

            public Builder players(Collection<String> players) {
                this.players.addAll((Collection)Preconditions.checkNotNull(players, (Object)"players"));
                return this;
            }

            public Builder players(String ... players) {
                this.players.addAll(Arrays.asList((String[])Preconditions.checkNotNull((Object)players, (Object)"players")));
                return this;
            }

            public Builder clearPlayers() {
                this.players.clear();
                return this;
            }

            public Builder serverVersion(String serverVersion) {
                this.serverVersion = (String)Preconditions.checkNotNull((Object)serverVersion, (Object)"serverVersion");
                return this;
            }

            public Builder plugins(Collection<PluginInformation> plugins) {
                this.plugins.addAll((Collection)Preconditions.checkNotNull(plugins, (Object)"plugins"));
                return this;
            }

            public Builder plugins(PluginInformation ... plugins) {
                this.plugins.addAll(Arrays.asList((PluginInformation[])Preconditions.checkNotNull((Object)plugins, (Object)"plugins")));
                return this;
            }

            public Builder clearPlugins() {
                this.plugins.clear();
                return this;
            }

            public QueryResponse build() {
                return new QueryResponse((String)Preconditions.checkNotNull((Object)this.motd, (Object)"motd"), (String)Preconditions.checkNotNull((Object)this.gameVersion, (Object)"gameVersion"), (String)Preconditions.checkNotNull((Object)this.map, (Object)"map"), this.currentPlayers, this.maxPlayers, (String)Preconditions.checkNotNull((Object)this.hostname, (Object)"hostname"), this.port, (Collection<String>)ImmutableList.copyOf(this.players), (String)Preconditions.checkNotNull((Object)this.serverVersion, (Object)"serverVersion"), (Collection<PluginInformation>)ImmutableList.copyOf(this.plugins));
            }
        }

        public static class PluginInformation {
            private String name;
            private String version;

            public PluginInformation(String name, String version) {
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
                this.version = (String)Preconditions.checkNotNull((Object)version, (Object)"version");
            }

            public String getName() {
                return this.name;
            }

            public void setName(String name) {
                this.name = name;
            }

            public void setVersion(String version) {
                this.version = version;
            }

            public String getVersion() {
                return this.version;
            }

            public static PluginInformation of(String name, String version) {
                return new PluginInformation(name, version);
            }
        }
    }
}

