/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.inventory;

import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ComplexRecipe;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.SmithingRecipe;
import org.bukkit.inventory.meta.trim.TrimPattern;
import org.jetbrains.annotations.NotNull;

public class SmithingTrimRecipe
extends SmithingRecipe
implements ComplexRecipe {
    private final RecipeChoice template;
    private final TrimPattern pattern;

    public SmithingTrimRecipe(@NotNull NamespacedKey key, @NotNull RecipeChoice template, @NotNull RecipeChoice base, @NotNull RecipeChoice addition, @NotNull TrimPattern pattern) {
        super(key, new ItemStack(Material.AIR), base, addition);
        this.template = template == null ? RecipeChoice.empty() : template.validate(true).clone();
        this.pattern = pattern;
    }

    public SmithingTrimRecipe(@NotNull NamespacedKey key, @NotNull RecipeChoice template, @NotNull RecipeChoice base, @NotNull RecipeChoice addition, @NotNull TrimPattern pattern, boolean copyDataComponents) {
        super(key, new ItemStack(Material.AIR), base, addition, copyDataComponents);
        this.template = template == null ? RecipeChoice.empty() : template.validate(true).clone();
        this.pattern = pattern;
    }

    @Deprecated(since="1.21.5", forRemoval=true)
    public SmithingTrimRecipe(@NotNull NamespacedKey key, @NotNull RecipeChoice template, @NotNull RecipeChoice base, @NotNull RecipeChoice addition) {
        this(key, template, base, addition, SmithingTrimRecipe.patternFromTemplate(template));
    }

    @Deprecated(since="1.21.5", forRemoval=true)
    public SmithingTrimRecipe(@NotNull NamespacedKey key, @NotNull RecipeChoice template, @NotNull RecipeChoice base, @NotNull RecipeChoice addition, boolean copyDataComponents) {
        this(key, template, base, addition, SmithingTrimRecipe.patternFromTemplate(template), copyDataComponents);
    }

    @NotNull
    public RecipeChoice getTemplate() {
        return this.template != null ? this.template.clone() : null;
    }

    @NotNull
    public TrimPattern getTrimPattern() {
        return this.pattern;
    }

    private static TrimPattern patternFromTemplate(@NotNull RecipeChoice template) {
        if (template instanceof RecipeChoice.ExactChoice) {
            RecipeChoice.ExactChoice exactChoice = (RecipeChoice.ExactChoice)template;
            return SmithingTrimRecipe.patternFromMaterial(exactChoice.getItemStack().getType());
        }
        if (template instanceof RecipeChoice.MaterialChoice) {
            RecipeChoice.MaterialChoice materialChoice = (RecipeChoice.MaterialChoice)template;
            return SmithingTrimRecipe.patternFromMaterial(materialChoice.getItemStack().getType());
        }
        return TrimPattern.BOLT;
    }

    private static TrimPattern patternFromMaterial(@NotNull Material material) {
        return switch (material) {
            case Material.BOLT_ARMOR_TRIM_SMITHING_TEMPLATE -> TrimPattern.BOLT;
            case Material.COAST_ARMOR_TRIM_SMITHING_TEMPLATE -> TrimPattern.COAST;
            case Material.DUNE_ARMOR_TRIM_SMITHING_TEMPLATE -> TrimPattern.DUNE;
            case Material.EYE_ARMOR_TRIM_SMITHING_TEMPLATE -> TrimPattern.EYE;
            case Material.FLOW_ARMOR_TRIM_SMITHING_TEMPLATE -> TrimPattern.FLOW;
            case Material.HOST_ARMOR_TRIM_SMITHING_TEMPLATE -> TrimPattern.HOST;
            case Material.RAISER_ARMOR_TRIM_SMITHING_TEMPLATE -> TrimPattern.RAISER;
            case Material.RIB_ARMOR_TRIM_SMITHING_TEMPLATE -> TrimPattern.RIB;
            case Material.SENTRY_ARMOR_TRIM_SMITHING_TEMPLATE -> TrimPattern.SENTRY;
            case Material.SHAPER_ARMOR_TRIM_SMITHING_TEMPLATE -> TrimPattern.SHAPER;
            case Material.SILENCE_ARMOR_TRIM_SMITHING_TEMPLATE -> TrimPattern.SILENCE;
            case Material.SNOUT_ARMOR_TRIM_SMITHING_TEMPLATE -> TrimPattern.SNOUT;
            case Material.SPIRE_ARMOR_TRIM_SMITHING_TEMPLATE -> TrimPattern.SPIRE;
            case Material.TIDE_ARMOR_TRIM_SMITHING_TEMPLATE -> TrimPattern.TIDE;
            case Material.VEX_ARMOR_TRIM_SMITHING_TEMPLATE -> TrimPattern.VEX;
            case Material.WARD_ARMOR_TRIM_SMITHING_TEMPLATE -> TrimPattern.WARD;
            case Material.WAYFINDER_ARMOR_TRIM_SMITHING_TEMPLATE -> TrimPattern.WAYFINDER;
            case Material.WILD_ARMOR_TRIM_SMITHING_TEMPLATE -> TrimPattern.WILD;
            default -> TrimPattern.BOLT;
        };
    }
}

