/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.event.vehicle;

import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;
import org.bukkit.event.vehicle.VehicleEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class VehicleExitEvent
extends VehicleEvent
implements Cancellable {
    private static final HandlerList HANDLER_LIST = new HandlerList();
    private final LivingEntity exited;
    private final boolean isCancellable;
    private boolean cancelled;

    @ApiStatus.Internal
    public VehicleExitEvent(@NotNull Vehicle vehicle, @NotNull LivingEntity exited, boolean isCancellable) {
        super(vehicle);
        this.exited = exited;
        this.isCancellable = isCancellable;
    }

    @ApiStatus.Internal
    public VehicleExitEvent(@NotNull Vehicle vehicle, @NotNull LivingEntity exited) {
        this(vehicle, exited, true);
    }

    @NotNull
    public LivingEntity getExited() {
        return this.exited;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean cancel) {
        if (cancel && !this.isCancellable) {
            return;
        }
        this.cancelled = cancel;
    }

    public boolean isCancellable() {
        return this.isCancellable;
    }

    @Override
    @NotNull
    public HandlerList getHandlers() {
        return HANDLER_LIST;
    }

    @NotNull
    public static HandlerList getHandlerList() {
        return HANDLER_LIST;
    }
}

