/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper;

import com.google.common.base.Preconditions;
import java.util.Collection;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated(since="1.16.5")
public final class Title {
    public static final int DEFAULT_FADE_IN = 20;
    public static final int DEFAULT_STAY = 200;
    public static final int DEFAULT_FADE_OUT = 20;
    private final BaseComponent[] title;
    private final BaseComponent[] subtitle;
    private final int fadeIn;
    private final int stay;
    private final int fadeOut;

    public Title(@NotNull BaseComponent title) {
        this(title, null);
    }

    public Title(@NotNull BaseComponent[] title) {
        this(title, null);
    }

    public Title(@NotNull String title) {
        this(title, null);
    }

    public Title(@NotNull BaseComponent title, @Nullable BaseComponent subtitle) {
        this(title, subtitle, 20, 200, 20);
    }

    public Title(@NotNull BaseComponent[] title, @Nullable BaseComponent[] subtitle) {
        this(title, subtitle, 20, 200, 20);
    }

    public Title(@NotNull String title, @Nullable String subtitle) {
        this(title, subtitle, 20, 200, 20);
    }

    public Title(@NotNull BaseComponent title, @Nullable BaseComponent subtitle, int fadeIn, int stay, int fadeOut) {
        BaseComponent[] baseComponentArray;
        BaseComponent[] baseComponentArray2 = new BaseComponent[]{(BaseComponent)Preconditions.checkNotNull((Object)title, (Object)"title")};
        if (subtitle == null) {
            baseComponentArray = null;
        } else {
            BaseComponent[] baseComponentArray3 = new BaseComponent[1];
            baseComponentArray = baseComponentArray3;
            baseComponentArray3[0] = subtitle;
        }
        this(baseComponentArray2, baseComponentArray, fadeIn, stay, fadeOut);
    }

    public Title(@Nullable BaseComponent[] title, @NotNull BaseComponent[] subtitle, int fadeIn, int stay, int fadeOut) {
        Preconditions.checkArgument((fadeIn >= 0 ? 1 : 0) != 0, (String)"Negative fadeIn: %s", (int)fadeIn);
        Preconditions.checkArgument((stay >= 0 ? 1 : 0) != 0, (String)"Negative stay: %s", (int)stay);
        Preconditions.checkArgument((fadeOut >= 0 ? 1 : 0) != 0, (String)"Negative fadeOut: %s", (int)fadeOut);
        this.title = (BaseComponent[])Preconditions.checkNotNull((Object)title, (Object)"title");
        this.subtitle = subtitle;
        this.fadeIn = fadeIn;
        this.stay = stay;
        this.fadeOut = fadeOut;
    }

    public Title(@NotNull String title, @Nullable String subtitle, int fadeIn, int stay, int fadeOut) {
        this(TextComponent.fromLegacyText((String)((String)Preconditions.checkNotNull((Object)title, (Object)"title"))), subtitle == null ? null : TextComponent.fromLegacyText((String)subtitle), fadeIn, stay, fadeOut);
    }

    @NotNull
    public BaseComponent[] getTitle() {
        return this.title;
    }

    @Nullable
    public BaseComponent[] getSubtitle() {
        return this.subtitle;
    }

    public int getFadeIn() {
        return this.fadeIn;
    }

    public int getStay() {
        return this.stay;
    }

    public int getFadeOut() {
        return this.fadeOut;
    }

    public void send(@NotNull Player player) {
        player.sendTitle(this);
    }

    public void send(@NotNull Collection<? extends Player> players) {
        for (Player player : players) {
            player.sendTitle(this);
        }
    }

    public void send(@NotNull Player[] players) {
        for (Player player : players) {
            player.sendTitle(this);
        }
    }

    public void broadcast() {
        this.send(Bukkit.getOnlinePlayers());
    }

    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private BaseComponent[] title;
        private BaseComponent[] subtitle;
        private int fadeIn = 20;
        private int stay = 200;
        private int fadeOut = 20;

        @NotNull
        public Builder title(@NotNull BaseComponent title) {
            return this.title(new BaseComponent[]{(BaseComponent)Preconditions.checkNotNull((Object)title, (Object)"title")});
        }

        @NotNull
        public Builder title(@NotNull BaseComponent[] title) {
            this.title = (BaseComponent[])Preconditions.checkNotNull((Object)title, (Object)"title");
            return this;
        }

        @NotNull
        public Builder title(@NotNull String title) {
            return this.title(TextComponent.fromLegacyText((String)((String)Preconditions.checkNotNull((Object)title, (Object)"title"))));
        }

        @NotNull
        public Builder subtitle(@Nullable BaseComponent subtitle) {
            BaseComponent[] baseComponentArray;
            if (subtitle == null) {
                baseComponentArray = null;
            } else {
                BaseComponent[] baseComponentArray2 = new BaseComponent[1];
                baseComponentArray = baseComponentArray2;
                baseComponentArray2[0] = subtitle;
            }
            return this.subtitle(baseComponentArray);
        }

        @NotNull
        public Builder subtitle(@Nullable BaseComponent[] subtitle) {
            this.subtitle = subtitle;
            return this;
        }

        @NotNull
        public Builder subtitle(@Nullable String subtitle) {
            return this.subtitle(subtitle == null ? null : TextComponent.fromLegacyText((String)subtitle));
        }

        @NotNull
        public Builder fadeIn(int fadeIn) {
            Preconditions.checkArgument((fadeIn >= 0 ? 1 : 0) != 0, (String)"Negative fadeIn: %s", (int)fadeIn);
            this.fadeIn = fadeIn;
            return this;
        }

        @NotNull
        public Builder stay(int stay) {
            Preconditions.checkArgument((stay >= 0 ? 1 : 0) != 0, (String)"Negative stay: %s", (int)stay);
            this.stay = stay;
            return this;
        }

        @NotNull
        public Builder fadeOut(int fadeOut) {
            Preconditions.checkArgument((fadeOut >= 0 ? 1 : 0) != 0, (String)"Negative fadeOut: %s", (int)fadeOut);
            this.fadeOut = fadeOut;
            return this;
        }

        @NotNull
        public Title build() {
            Preconditions.checkState((this.title != null ? 1 : 0) != 0, (Object)"Title not specified");
            return new Title(this.title, this.subtitle, this.fadeIn, this.stay, this.fadeOut);
        }
    }
}

